/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.userfeedback.service;

import java.util.List;
import org.apache.jcs.access.exception.ObjectNotFoundException;
import org.fao.geonet.api.userfeedback.UserFeedbackUtils;
import org.fao.geonet.api.userfeedback.service.IUserFeedbackService;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.User;
import org.fao.geonet.domain.userfeedback.Rating;
import org.fao.geonet.domain.userfeedback.RatingCriteria;
import org.fao.geonet.domain.userfeedback.UserFeedback;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.userfeedback.RatingRepository;
import org.fao.geonet.repository.userfeedback.UserFeedbackRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class UserFeedbackDatabaseService
implements IUserFeedbackService {
    @Autowired
    IMetadataUtils dataManager;
    @Autowired
    MetadataRepository metadataRepository;
    @Autowired
    RatingRepository ratingRepository;
    @Autowired
    UserFeedbackRepository userFeedbackRepository;
    @Autowired
    UserRepository userRepository;

    @Override
    public void publishUserFeedback(String feedbackUuid, User user) throws ObjectNotFoundException {
        UserFeedback userFeedback = this.userFeedbackRepository.findByUuid(feedbackUuid);
        if (userFeedback == null) {
            throw new ObjectNotFoundException();
        }
        userFeedback.setStatus(UserFeedback.UserRatingStatus.PUBLISHED);
        userFeedback.setApprover(user);
        this.userFeedbackRepository.save((Object)userFeedback);
    }

    @Override
    public void removeUserFeedback(String feedbackUuid, String ip) throws Exception {
        UserFeedback userFeedback = this.userFeedbackRepository.findByUuid(feedbackUuid);
        Metadata metadata = userFeedback.getMetadata();
        this.userFeedbackRepository.delete((Object)userFeedback);
        List<UserFeedback> listFeedbacks = this.retrieveUserFeedbackForMetadata(metadata.getUuid(), -1, true);
        Integer average = 0;
        if (listFeedbacks.size() > 0) {
            UserFeedbackUtils.RatingAverage averageRating = new UserFeedbackUtils().getAverage(listFeedbacks);
            average = averageRating.getRatingAverages().get(RatingCriteria.AVERAGE_ID);
        }
        this.dataManager.rateMetadata(metadata.getId(), ip, average.intValue());
    }

    @Override
    public List<Rating> retrieveMetadataRatings(String metadataUuid, boolean published) {
        return this.ratingRepository.findByMetadata_Uuid(metadataUuid);
    }

    @Override
    public List<UserFeedback> retrieveUserFeedback(int maxSize, boolean published) {
        List result = null;
        if (published) {
            PageRequest pageSize = null;
            if (maxSize > 0) {
                pageSize = PageRequest.of((int)0, (int)maxSize);
            }
            result = this.userFeedbackRepository.findByStatusOrderByCreationDateDesc(UserFeedback.UserRatingStatus.PUBLISHED, (Pageable)pageSize);
        } else {
            PageRequest pageSize = null;
            if (maxSize > 0) {
                pageSize = PageRequest.of((int)0, (int)maxSize);
            }
            result = this.userFeedbackRepository.findByOrderByCreationDateDesc((Pageable)pageSize);
        }
        return result;
    }

    @Override
    public UserFeedback retrieveUserFeedback(String feedbackUuid, boolean published) {
        if (published) {
            return this.userFeedbackRepository.findByUuidAndStatus(feedbackUuid, UserFeedback.UserRatingStatus.PUBLISHED);
        }
        return this.userFeedbackRepository.findByUuid(feedbackUuid);
    }

    @Override
    public List<UserFeedback> retrieveUserFeedbackForMetadata(String metadataUuid, int maxSize, boolean published) {
        List result = null;
        if (published) {
            PageRequest pageSize = null;
            if (maxSize > 0) {
                pageSize = PageRequest.of((int)0, (int)maxSize);
            }
            result = this.userFeedbackRepository.findByMetadata_UuidAndStatusOrderByCreationDateDesc(metadataUuid, UserFeedback.UserRatingStatus.PUBLISHED, (Pageable)pageSize);
        } else {
            PageRequest pageSize = null;
            if (maxSize > 0) {
                pageSize = PageRequest.of((int)0, (int)maxSize);
            }
            result = this.userFeedbackRepository.findByMetadata_UuidOrderByCreationDateDesc(metadataUuid, (Pageable)pageSize);
        }
        return result;
    }

    @Override
    public void saveUserFeedback(UserFeedback userFeedback, String ip) throws Exception {
        if (userFeedback.getAuthorId() != null) {
            User author = this.userRepository.findOneByUsername(userFeedback.getAuthorId().getUsername());
            userFeedback.setAuthorId(author);
        }
        if (userFeedback.getApprover() != null) {
            User approver = this.userRepository.findOneByUsername(userFeedback.getApprover().getUsername());
            userFeedback.setApprover(approver);
        }
        Metadata metadata = this.metadataRepository.findOneByUuid(userFeedback.getMetadata().getUuid());
        userFeedback.setMetadata(metadata);
        if (userFeedback.getCreationDate() == null) {
            userFeedback.setCreationDate(new ISODate(System.currentTimeMillis()).toDate());
        }
        this.userFeedbackRepository.save((Object)userFeedback);
        UserFeedbackUtils.RatingAverage averageRating = new UserFeedbackUtils().getAverage(this.retrieveUserFeedbackForMetadata(metadata.getUuid(), -1, true));
        Integer average = averageRating.getRatingAverages().get(RatingCriteria.AVERAGE_ID);
        if (average != null) {
            this.dataManager.rateMetadata(metadata.getId(), ip, averageRating.getRatingAverages().get(RatingCriteria.AVERAGE_ID).intValue());
        }
    }
}

