/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.reports;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.persistence.metamodel.SingularAttribute;
import jeeves.server.context.ServiceContext;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.api.reports.IReport;
import org.fao.geonet.api.reports.ReportFilter;
import org.fao.geonet.api.reports.ReportUtils;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataFileDownload;
import org.fao.geonet.domain.MetadataFileDownload_;
import org.fao.geonet.domain.MetadataFileUpload;
import org.fao.geonet.domain.User;
import org.fao.geonet.repository.MetadataFileDownloadRepository;
import org.fao.geonet.repository.MetadataFileUploadRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.specification.MetadataFileDownloadSpecs;
import org.fao.geonet.repository.specification.MetadataFileUploadSpecs;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;

public class ReportDownloads
implements IReport {
    private final ReportFilter reportFilter;
    @Autowired
    MetadataRepository metadataRepository;

    public ReportDownloads(ReportFilter filter) {
        this.reportFilter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(ServiceContext context, PrintWriter writer) throws Exception {
        CSVPrinter csvFilePrinter = null;
        try {
            csvFilePrinter = new CSVPrinter((Appendable)writer, ReportUtils.CSV_FORMAT);
            MetadataFileDownloadRepository downloadRepository = (MetadataFileDownloadRepository)context.getBean(MetadataFileDownloadRepository.class);
            Sort sort = Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{SortUtils.createPath((SingularAttribute[])new SingularAttribute[]{MetadataFileDownload_.downloadDate})});
            List records = downloadRepository.findAll(MetadataFileDownloadSpecs.downloadDateBetweenAndByGroups((ISODate)this.reportFilter.getBeginDate(), (ISODate)this.reportFilter.getEndDate(), this.reportFilter.getGroups()), sort);
            csvFilePrinter.printRecord(new Object[]{"Metadata file downloads"});
            csvFilePrinter.println();
            String[] entries = "Metadata ID#Metadata Title#File download#File download date#Requester name#Requester mail#Requester organisation#Requester comments#Username#Surname#Name#Email#Profile#Delete date".split("#");
            csvFilePrinter.printRecord(Arrays.asList(entries));
            MetadataFileUploadRepository uploadRepo = (MetadataFileUploadRepository)context.getBean(MetadataFileUploadRepository.class);
            List users = ((UserRepository)context.getBean(UserRepository.class)).findAll();
            for (MetadataFileDownload fileDownload : records) {
                int fileUploadId = fileDownload.getFileUploadId();
                MetadataFileUpload metadataFileUpload = (MetadataFileUpload)uploadRepo.findOne(MetadataFileUploadSpecs.hasId((int)fileUploadId)).get();
                String username = metadataFileUpload.getUserName();
                String name = "";
                String surname = "";
                String email = "";
                String profile = "";
                String requesterName = "";
                String requesterMail = "";
                Optional<User> userFilter = users.stream().filter(u -> u.getUsername().equals(username)).findFirst();
                if (userFilter.isPresent()) {
                    User user = userFilter.get();
                    name = Optional.ofNullable(user.getName()).orElse("");
                    surname = Optional.ofNullable(user.getSurname()).orElse("");
                    email = Optional.ofNullable(user.getEmail()).orElse("");
                    profile = user.getProfile().name();
                    requesterName = fileDownload.getRequesterName();
                    requesterMail = fileDownload.getRequesterMail();
                    if (StringUtils.isEmpty((String)requesterName) && StringUtils.isNotEmpty((String)fileDownload.getUserName())) {
                        Optional<User> userDownloadFilter = users.stream().filter(u -> u.getUsername().equals(fileDownload.getUserName())).findFirst();
                        if (userFilter.isPresent()) {
                            User userDownload = userDownloadFilter.get();
                            requesterName = userDownload.getName() + " " + userDownload.getSurname();
                            requesterMail = userDownload.getEmail();
                        }
                    }
                }
                Optional metadata = this.metadataRepository.findById((Object)fileDownload.getMetadataId());
                String metadataUuid = ((Metadata)metadata.get()).getUuid();
                String metadataTitle = ReportUtils.retrieveMetadataTitle(metadataUuid);
                ArrayList<String> record = new ArrayList<String>();
                record.add(metadataUuid);
                record.add(metadataTitle);
                record.add(fileDownload.getFileName());
                record.add(fileDownload.getDownloadDate());
                record.add(requesterName);
                record.add(requesterMail);
                record.add(fileDownload.getRequesterOrg());
                record.add(fileDownload.getRequesterComments());
                record.add(username);
                record.add(surname);
                record.add(name);
                record.add(email);
                record.add(profile);
                record.add(metadataFileUpload.getDeletedDate());
                csvFilePrinter.printRecord(record);
            }
        }
        finally {
            writer.flush();
            if (csvFilePrinter != null) {
                csvFilePrinter.flush();
            }
        }
    }
}

