/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.registries;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.awt.RenderingHints;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.ZipUtil;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.processing.report.SimpleMetadataProcessingReport;
import org.fao.geonet.api.registries.CollectResults;
import org.fao.geonet.api.registries.DirectoryUtils;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.mef.MEFLib;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.kernel.search.index.BatchOpsMetadataReindexer;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.utils.Xml;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.geotools.wfs.GML;
import org.jdom.Content;
import org.jdom.Element;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@EnableWebMvc
@Service
@RequestMapping(value={"/{portal}/api/registries/actions/entries"})
@Tag(name="registries", description="Registries related operations")
public class DirectoryApi {
    public static final String LOGGER = "geonetwork.registries.directory";
    public static final String API_SYNCHRONIZE_ENTRIES_NOTE = "Scan one or more records for element matching the XPath provided and then check if this element is available in the directory. If Found, the element from the directory update the element in the record and optionally text or attribute value properties are preserved using propertiesToCopy. Elements can be lost if not existing in the directory entry (eg. from an gex:Extent directory containing only description and bounding polygon, the update can remove temporal element).<br/><br/>The identifier XPath is used to find a match. An optional filtercan be added to restrict search to a subset of the directory. If no identifier XPaths is provided, the UUID is based on the content of the snippet (hash). It is recommended to use an identifier for better matching (eg. ISO19139 contact with different roles will not match on the automatic UUID mode).";
    public static final String APIURL_ACTIONS_ENTRIES_COLLECT = "/collect";
    public static final String APIURL_ACTIONS_ENTRIES_SYNCHRONIZE = "/synchronize";
    public static final String APIPARAM_XPATH = "XPath of the elements to extract as entry.";
    public static final String APIPARAM_IDENTIFIER_XPATH = "XPath of the element identifier. If not defined a random UUID is generated and analysis will not check for duplicates.";
    public static final String APIPARAM_PROPERTIESTOCOPY = "List of XPath of properties to copy from record to matching entry. Only support text or attribute eg. ./gmd:role/*/@codeListValue";
    public static final String APIPARAM_REPLACEWITHXLINK = "Replace entry by XLink.";
    public static final String APIPARAM_DIRECTORYFILTERQUERY = "Filter query for directory search.";
    private static final String API_COLLECT_ENTRIES_NOTE = "Scan one or more records for element matching the XPath provided and save them as directory entries (ie. subtemplate).<br/><br/>Only records that the current user can edit are analyzed.<br/><br/>Examples:<br/>For ISO19115-3 records, use .//cit:CI_Responsibility and compute identifier based on email with .//cit:electronicMailAddress/*/text() to create a contact directory.";
    @Autowired
    DataManager dataManager;
    @Autowired
    SettingManager settingManager;
    @Autowired
    IMetadataUtils metadataRepository;
    @Autowired
    AccessManager accessManager;

    @Operation(summary="Preview directory entries extracted from records", description="Scan one or more records for element matching the XPath provided and save them as directory entries (ie. subtemplate).<br/><br/>Only records that the current user can edit are analyzed.<br/><br/>Examples:<br/>For ISO19115-3 records, use .//cit:CI_Responsibility and compute identifier based on email with .//cit:electronicMailAddress/*/text() to create a contact directory.")
    @RequestMapping(value={"/collect"}, method={RequestMethod.GET}, produces={"application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasAuthority('Reviewer')")
    public ResponseEntity<Object> previewExtractedEntries(@Parameter(description="Record UUIDs. If null current selection is used.", required=false, example="") @RequestParam(required=false) String[] uuids, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @Parameter(description="XPath of the elements to extract as entry.", required=true, example=".//gmd:CI_ResponsibleParty") @RequestParam(required=true) String xpath, @Parameter(description="XPath of the element identifier. If not defined a random UUID is generated and analysis will not check for duplicates.", required=false, example="@uuid") @RequestParam(required=false) String identifierXpath, HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        return this.collectEntries(context, uuids, bucket, xpath, identifierXpath, false, null);
    }

    @Operation(summary="Extracts directory entries from records", description="Scan one or more records for element matching the XPath provided and save them as directory entries (ie. subtemplate).<br/><br/>Only records that the current user can edit are analyzed.<br/><br/>Examples:<br/>For ISO19115-3 records, use .//cit:CI_Responsibility and compute identifier based on email with .//cit:electronicMailAddress/*/text() to create a contact directory.")
    @RequestMapping(value={"/collect"}, method={RequestMethod.PUT}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Reviewer')")
    @ResponseStatus(value=HttpStatus.OK)
    public ResponseEntity<Object> extractEntries(@Parameter(description="Record UUIDs. If null current selection is used.", required=false, example="") @RequestParam(required=false) String[] uuids, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @Parameter(description="XPath of the elements to extract as entry.", required=true, example=".//gmd:CI_ResponsibleParty") @RequestParam(required=true) String xpath, @Parameter(description="XPath of the element identifier. If not defined a random UUID is generated and analysis will not check for duplicates.", required=false, example="@uuid") @RequestParam(required=false) String identifierXpath, HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        return this.collectEntries(context, uuids, bucket, xpath, identifierXpath, true, null);
    }

    private ResponseEntity<Object> collectEntries(ServiceContext context, String[] uuids, String bucket, String xpath, String identifierXpath, boolean save, String directoryFilterQuery) throws Exception {
        UserSession session = context.getUserSession();
        Set<String> setOfUuidsToEdit = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, session);
        SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();
        HashSet listOfEntries = new HashSet();
        HashSet<Integer> listOfEntriesInternalId = new HashSet<Integer>();
        int user = context.getUserSession().getUserIdAsInt();
        String siteId = this.settingManager.getSiteId();
        for (String recordUuid : setOfUuidsToEdit) {
            AbstractMetadata record = this.metadataRepository.findOneByUuid(recordUuid);
            if (record == null) {
                report.incrementNullRecords();
                continue;
            }
            if (!this.accessManager.canEdit(context, String.valueOf(record.getId()))) {
                report.addNotEditableMetadataId(record.getId());
                continue;
            }
            try {
                CollectResults collectResults = DirectoryUtils.collectEntries(context, record, xpath, identifierXpath);
                if (save) {
                    DirectoryUtils.saveEntries(context, collectResults, siteId, user, 1, false);
                    listOfEntriesInternalId.addAll(collectResults.getEntryIdentifiers().values());
                    report.incrementProcessedRecords();
                    report.addMetadataInfos(record, String.format("%d entry(ies) extracted from record '%s'. UUID(s): %s", collectResults.getEntryIdentifiers().size(), record.getUuid(), collectResults.getEntryIdentifiers().toString()));
                    continue;
                }
                listOfEntries.addAll(collectResults.getEntries().values());
            }
            catch (Exception ex) {
                report.addMetadataError(record, ex);
            }
        }
        if (save) {
            this.dataManager.flush();
            BatchOpsMetadataReindexer r = new BatchOpsMetadataReindexer(this.dataManager, listOfEntriesInternalId);
            r.process(this.settingManager.getSiteId());
            report.close();
            return new ResponseEntity((Object)report, HttpStatus.CREATED);
        }
        Element response = new Element("entries");
        for (Element e : listOfEntries) {
            response.addContent((Content)e);
        }
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @Operation(summary="Preview updated matching entries in records", description="Scan one or more records for element matching the XPath provided and then check if this element is available in the directory. If Found, the element from the directory update the element in the record and optionally text or attribute value properties are preserved using propertiesToCopy. Elements can be lost if not existing in the directory entry (eg. from an gex:Extent directory containing only description and bounding polygon, the update can remove temporal element).<br/><br/>The identifier XPath is used to find a match. An optional filtercan be added to restrict search to a subset of the directory. If no identifier XPaths is provided, the UUID is based on the content of the snippet (hash). It is recommended to use an identifier for better matching (eg. ISO19139 contact with different roles will not match on the automatic UUID mode).")
    @RequestMapping(value={"/synchronize"}, method={RequestMethod.GET}, produces={"application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ResponseEntity<Object> previewUpdatedRecordEntries(@Parameter(description="Record UUIDs. If null current selection is used.", required=false, example="") @RequestParam(required=false) String[] uuids, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @Parameter(description="XPath of the elements to extract as entry.", required=true, example=".//gmd:CI_ResponsibleParty") @RequestParam(required=true) String xpath, @Parameter(description="XPath of the element identifier. If not defined a random UUID is generated and analysis will not check for duplicates.", required=false, example="@uuid or .//gmd:electronicMailAddress/gco:CharacterString/text()") @RequestParam(required=false) String identifierXpath, @Parameter(description="List of XPath of properties to copy from record to matching entry. Only support text or attribute eg. ./gmd:role/*/@codeListValue", required=false, example="./gmd:role/*/@codeListValue") @RequestParam(required=false) List<String> propertiesToCopy, @Parameter(description="Replace entry by XLink.", required=false, example="@uuid") @RequestParam(required=false, defaultValue="false") boolean substituteAsXLink, @Parameter(description="Filter query for directory search.", required=false, example="groupPublished:IFREMER") @RequestParam(required=false) String fq, HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        return this.updateRecordEntries(context, uuids, bucket, xpath, identifierXpath, propertiesToCopy, substituteAsXLink, false, fq);
    }

    @Operation(summary="Update matching entries in records", description="Scan one or more records for element matching the XPath provided and then check if this element is available in the directory. If Found, the element from the directory update the element in the record and optionally text or attribute value properties are preserved using propertiesToCopy. Elements can be lost if not existing in the directory entry (eg. from an gex:Extent directory containing only description and bounding polygon, the update can remove temporal element).<br/><br/>The identifier XPath is used to find a match. An optional filtercan be added to restrict search to a subset of the directory. If no identifier XPaths is provided, the UUID is based on the content of the snippet (hash). It is recommended to use an identifier for better matching (eg. ISO19139 contact with different roles will not match on the automatic UUID mode).")
    @RequestMapping(value={"/synchronize"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasAuthority('Reviewer')")
    @ResponseBody
    public ResponseEntity<Object> updateRecordEntries(@Parameter(description="Record UUIDs. If null current selection is used.", required=false, example="") @RequestParam(required=false) String[] uuids, @Parameter(description="Selection bucket name", required=false) @RequestParam(required=false) String bucket, @Parameter(description="XPath of the elements to extract as entry.", required=true, example=".//gmd:CI_ResponsibleParty") @RequestParam(required=true) String xpath, @Parameter(description="XPath of the element identifier. If not defined a random UUID is generated and analysis will not check for duplicates.", required=false, example="@uuid") @RequestParam(required=false) String identifierXpath, @Parameter(description="List of XPath of properties to copy from record to matching entry. Only support text or attribute eg. ./gmd:role/*/@codeListValue", required=false, example="./gmd:role/*/@codeListValue") @RequestParam(required=false) List<String> propertiesToCopy, @Parameter(description="Replace entry by XLink.", required=false) @RequestParam(required=false, defaultValue="false") boolean substituteAsXLink, @Parameter(description="Filter query for directory search.", required=false, example="groupPublished:IFREMER") @RequestParam(required=false) String fq, HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        return this.updateRecordEntries(context, uuids, bucket, xpath, identifierXpath, propertiesToCopy, substituteAsXLink, true, fq);
    }

    private ResponseEntity<Object> updateRecordEntries(ServiceContext context, String[] uuids, String bucket, String xpath, String identifierXpath, List<String> propertiesToCopy, boolean substituteAsXLink, boolean save, String directoryFilterQuery) throws Exception {
        UserSession session = context.getUserSession();
        Profile profile = session.getProfile();
        Set<String> setOfUuidsToEdit = ApiUtils.getUuidsParameterOrSelection(uuids, bucket, session);
        HashSet<Element> listOfUpdatedRecord = new HashSet<Element>();
        HashSet<Integer> listOfRecordInternalId = new HashSet<Integer>();
        SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();
        boolean validate = false;
        boolean ufo = false;
        boolean index = false;
        report.setTotalRecords(setOfUuidsToEdit.size());
        for (String recordUuid : setOfUuidsToEdit) {
            AbstractMetadata record = this.metadataRepository.findOneByUuid(recordUuid);
            if (record == null) {
                report.incrementNullRecords();
                continue;
            }
            if (!this.accessManager.canEdit(context, String.valueOf(record.getId()))) {
                report.addNotEditableMetadataId(record.getId());
                continue;
            }
            try {
                CollectResults collectResults = DirectoryUtils.synchronizeEntries(context, record, xpath, identifierXpath, propertiesToCopy, substituteAsXLink, directoryFilterQuery);
                listOfRecordInternalId.add(record.getId());
                if (save && collectResults.isRecordUpdated()) {
                    try {
                        this.dataManager.updateMetadata(context, "" + record.getId(), collectResults.getUpdatedRecord(), validate, ufo, index, context.getLanguage(), new ISODate().toString(), true);
                        listOfRecordInternalId.add(record.getId());
                        report.addMetadataInfos(record, "Metadata updated.");
                    }
                    catch (Exception e) {
                        report.addMetadataError(record, e);
                    }
                } else if (collectResults.isRecordUpdated()) {
                    listOfUpdatedRecord.add(collectResults.getUpdatedRecord());
                }
                report.incrementProcessedRecords();
            }
            catch (Exception e) {
                report.addMetadataError(record, e);
            }
        }
        if (save) {
            this.dataManager.flush();
            BatchOpsMetadataReindexer r = new BatchOpsMetadataReindexer(this.dataManager, listOfRecordInternalId);
            r.process(this.settingManager.getSiteId());
            report.close();
            return new ResponseEntity((Object)report, HttpStatus.CREATED);
        }
        Element response = new Element("records");
        for (Element e : listOfUpdatedRecord) {
            response.addContent((Content)e);
        }
        report.close();
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @Operation(summary="Import spatial directory entries", description="Directory entry (AKA subtemplates) are XML fragments that can be inserted in metadata records. Use this service to import geographic extent entries from an ESRI Shapefile format.")
    @RequestMapping(value={"/import/spatial"}, method={RequestMethod.POST}, consumes={"multipart/form-data"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Directory entries imported."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Reviewvers can access it.")})
    @PreAuthorize(value="hasAuthority('Reviewer')")
    @ResponseBody
    public SimpleMetadataProcessingReport importSpatialEntries(@Parameter(description="The ZIP file to upload containing the Shapefile.", required=true) @RequestParam(value="file") MultipartFile file, @Parameter(description="Attribute to use for UUID. If none, random UUID are generated.", required=false) @RequestParam(required=false) String uuidAttribute, @Parameter(description="Pattern to build UUID from. Default is '{{uuid}}'.", required=false) @RequestParam(defaultValue="{{uuid}}", required=false) String uuidPattern, @Parameter(description="Attribute to use for extent description. If none, no extent description defined. TODO: Add per language desc ?", required=false) @RequestParam(required=false) String descriptionAttribute, @Parameter(description="geomProjectionTo", required=false) @RequestParam(required=false) String geomProjectionTo, @Parameter(description="lenient", required=false) @RequestParam(required=false) boolean lenient, @Parameter(description="Attribute table charset", required=false) @RequestParam(required=false, defaultValue="") String charset, @Parameter(description="Create only bounding box for each spatial objects.", required=false) @RequestParam(required=false, defaultValue="true") boolean onlyBoundingBox, @Parameter(description="Process", required=false) @RequestParam(required=false) String process, @Parameter(description="Schema identifier", required=false) @RequestParam(required=false) String schema, @Parameter(description="Record identifier processing.", required=false) @RequestParam(required=false, defaultValue="NOTHING") MEFLib.UuidAction uuidProcessing, @Parameter(description="The group the record is attached to.", required=false) @RequestParam(required=false) Integer group, @Parameter(hidden=true) MultipartHttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext((HttpServletRequest)request);
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        MetadataSchema metadataSchema = this.dataManager.getSchema(schema);
        Path xslProcessing = metadataSchema.getSchemaDir().resolve("process").resolve(process + ".xsl");
        File[] shapeFiles = this.unzipAndFilterShp(file);
        CollectResults collectResults = new CollectResults();
        SimpleMetadataProcessingReport report = new SimpleMetadataProcessingReport();
        for (File shapeFile : shapeFiles) {
            SimpleFeatureCollection collection = this.shapeFileToFeatureCollection(shapeFile, charset);
            try (SimpleFeatureIterator features = collection.features();){
                while (features.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)features.next();
                    String uuid = this.computeUuid(uuidAttribute, uuidPattern, feature);
                    String description = this.computeDescription(descriptionAttribute, feature);
                    Envelope wgsEnvelope = this.computeEnvelope(feature);
                    Geometry featureGeometry = this.reprojGeom(geomProjectionTo, lenient, feature);
                    String xmlGeometry = this.geometryToXml(featureGeometry, (SimpleFeatureType)collection.getSchema());
                    HashMap<String, Object> parameters = new HashMap<String, Object>();
                    parameters.put("uuid", uuid);
                    parameters.put("description", description);
                    parameters.put("east", wgsEnvelope.getMaxX());
                    parameters.put("north", wgsEnvelope.getMaxY());
                    parameters.put("west", wgsEnvelope.getMinX());
                    parameters.put("south", wgsEnvelope.getMinY());
                    parameters.put("onlyBoundingBox", onlyBoundingBox);
                    parameters.put("geometry", xmlGeometry);
                    Element subtemplate = new Element("root");
                    Element snippet = Xml.transform((Element)subtemplate, (Path)xslProcessing, parameters);
                    collectResults.getEntries().put((Object)uuid, (Object)uuid, (Object)snippet);
                }
            }
            report.addInfos(String.format("%d entries extracted from shapefile '%s'.", collection.size(), shapeFile.getName()));
        }
        report.setTotalRecords(collectResults.getEntries().size());
        if (collectResults.getEntries().size() > 0) {
            Metadata record = new Metadata();
            record.getDataInfo().setSchemaId(schema);
            collectResults.setRecord((AbstractMetadata)record);
            int user = context.getUserSession().getUserIdAsInt();
            String siteId = this.settingManager.getSiteId();
            Map<String, Exception> errors = DirectoryUtils.saveEntries(context, collectResults, siteId, user, group, false);
            this.dataManager.flush();
            HashSet<Integer> listOfRecordInternalId = new HashSet<Integer>();
            listOfRecordInternalId.addAll(collectResults.getEntryIdentifiers().values());
            report.addInfos(String.format("%d entries saved.", listOfRecordInternalId.size()));
            BatchOpsMetadataReindexer r = new BatchOpsMetadataReindexer(this.dataManager, listOfRecordInternalId);
            r.process(this.settingManager.getSiteId());
            errors.forEach((k, v) -> report.addError((Exception)v));
            report.close();
        } else {
            report.addInfos(String.format("No entry found in ZIP file '%s'", file.getOriginalFilename()));
            report.close();
        }
        return report;
    }

    private Geometry reprojGeom(String geomProjectionTo, boolean lenient, SimpleFeature feature) throws FactoryException, ResourceNotFoundException, TransformException {
        CoordinateReferenceSystem fromCrs = feature.getDefaultGeometryProperty().getDescriptor().getCoordinateReferenceSystem();
        CoordinateReferenceSystem toCrs = null;
        if (StringUtils.isNotEmpty((String)geomProjectionTo)) {
            try {
                toCrs = CRS.getAuthorityFactory((boolean)true).createCoordinateReferenceSystem(geomProjectionTo);
            }
            catch (NoSuchAuthorityCodeException ex) {
                throw new ResourceNotFoundException(String.format("Projection '%s' to convert geometry to not foundin EPSG database", geomProjectionTo));
            }
        }
        if (toCrs != null) {
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)fromCrs, (CoordinateReferenceSystem)toCrs, (boolean)lenient);
            return JTS.transform((Geometry)((Geometry)feature.getDefaultGeometry()), (MathTransform)transform);
        }
        return (Geometry)feature.getDefaultGeometry();
    }

    private String geometryToXml(Object geometry, SimpleFeatureType simpleFeatureType) throws IOException, SchemaException {
        GML gmlEncoder = new GML(GML.Version.WFS1_1);
        gmlEncoder.setNamespace("gn", "http://geonetwork-opensource.org");
        gmlEncoder.setBaseURL(new URL("http://geonetwork-opensource.org"));
        gmlEncoder.setEncoding(StandardCharsets.UTF_8);
        LinkedList<SimpleFeature> c = new LinkedList<SimpleFeature>();
        SimpleFeatureType TYPE = DataUtilities.createType((String)"http://geonetwork-opensource.org", (String)"the_geom", (String)"geom:Geometry");
        TYPE.getUserData().put("prefix", "gn");
        c.add(SimpleFeatureBuilder.build((SimpleFeatureType)TYPE, (Object[])new Object[]{geometry}, null));
        ByteArrayOutputStream outXml = new ByteArrayOutputStream();
        gmlEncoder.encode((OutputStream)outXml, (SimpleFeatureCollection)new ListFeatureCollection(simpleFeatureType, c));
        outXml.close();
        return outXml.toString();
    }

    private Envelope computeEnvelope(SimpleFeature feature) throws TransformException {
        BoundingBox bounds = feature.getBounds();
        return JTS.toGeographic((Envelope)new Envelope(bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY()), (CoordinateReferenceSystem)feature.getDefaultGeometryProperty().getDescriptor().getCoordinateReferenceSystem());
    }

    private String computeUuid(String uuidAttribute, String uuidPattern, SimpleFeature feature) {
        Object attribute;
        String featureUuidValue = null;
        if (StringUtils.isNotEmpty((String)uuidAttribute) && (attribute = feature.getAttribute(uuidAttribute)) != null) {
            featureUuidValue = attribute.toString();
        }
        String uuid = StringUtils.isNotEmpty(featureUuidValue) ? featureUuidValue : UUID.randomUUID().toString();
        return uuidPattern.replace("{{uuid}}", uuid);
    }

    private String computeDescription(String descriptionAttribute, SimpleFeature feature) {
        Object attribute;
        String featureDescriptionValue = "";
        if (StringUtils.isNotEmpty((String)descriptionAttribute) && (attribute = feature.getAttribute(descriptionAttribute)) != null) {
            featureDescriptionValue = attribute.toString();
        }
        return StringUtils.isNotEmpty((String)featureDescriptionValue) ? featureDescriptionValue : "";
    }

    private SimpleFeatureCollection shapeFileToFeatureCollection(File shapefile, String charset) throws IOException {
        HashMap<String, URL> map = new HashMap<String, URL>();
        map.put("url", shapefile.toURI().toURL());
        DataStore dataStore = DataStoreFinder.getDataStore(map);
        if (dataStore instanceof ShapefileDataStore && StringUtils.isNotEmpty((String)charset)) {
            ((ShapefileDataStore)dataStore).setCharset(Charset.forName(charset));
        }
        String typeName = dataStore.getTypeNames()[0];
        SimpleFeatureSource source = dataStore.getFeatureSource(typeName);
        Query query = new Query(typeName, (Filter)Filter.INCLUDE);
        query.setHints(new Hints((RenderingHints.Key)Hints.FEATURE_2D, (Object)true));
        return source.getFeatures(query);
    }

    private File[] unzipAndFilterShp(MultipartFile file) throws IOException, URISyntaxException {
        Path toDirectory = Files.createTempDirectory("gn-imported-entries-", new FileAttribute[0]);
        toDirectory.toFile().deleteOnExit();
        File zipFile = new File(Paths.get(toDirectory.toString(), file.getOriginalFilename()).toString());
        file.transferTo(zipFile);
        ZipUtil.extract((Path)zipFile.toPath(), (Path)toDirectory);
        File[] shapefiles = toDirectory.toFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".shp");
            }
        });
        return shapefiles;
    }
}

