/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.PathUtils;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springdoc.api.AbstractOpenApiResource;
import org.springdoc.core.AbstractRequestService;
import org.springdoc.core.ActuatorProvider;
import org.springdoc.core.GenericResponseService;
import org.springdoc.core.OpenAPIService;
import org.springdoc.core.OperationService;
import org.springdoc.core.SecurityOAuth2Provider;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.customizers.OpenApiCustomiser;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springdoc.webmvc.core.RouterFunctionProvider;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;

@RestController
public class OpenApiController
extends AbstractOpenApiResource {
    private final RequestMappingInfoHandlerMapping requestMappingHandlerMapping;
    private final Optional<ActuatorProvider> servletContextProvider;
    private final Optional<SecurityOAuth2Provider> springSecurityOAuth2Provider;
    private final Optional<RouterFunctionProvider> routerFunctionProvider;

    @Autowired
    public OpenApiController(ObjectFactory<OpenAPIService> openAPIBuilderObjectFactory, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, RequestMappingInfoHandlerMapping requestMappingHandlerMapping, Optional<ActuatorProvider> servletContextProvider, Optional<List<OperationCustomizer>> operationCustomizers, Optional<List<OpenApiCustomiser>> openApiCustomisers, SpringDocConfigProperties springDocConfigProperties, Optional<ActuatorProvider> actuatorProvider, Optional<SecurityOAuth2Provider> springSecurityOAuth2Provider, Optional<RouterFunctionProvider> routerFunctionProvider) {
        super("springdocDefault", openAPIBuilderObjectFactory, requestBuilder, responseBuilder, operationParser, operationCustomizers, openApiCustomisers, springDocConfigProperties, actuatorProvider);
        springDocConfigProperties.setPathsToExclude(Arrays.asList("/0.1/**"));
        springDocConfigProperties.setPackagesToScan(Arrays.asList("org.fao.geonet.api", "org.fao.geonet.monitor.service"));
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
        this.servletContextProvider = servletContextProvider;
        this.springSecurityOAuth2Provider = springSecurityOAuth2Provider;
        this.routerFunctionProvider = routerFunctionProvider;
    }

    @Operation(hidden=true)
    @GetMapping(value={"/{portal}/api/doc"}, produces={"application/json"})
    public String openapiJson(HttpServletRequest request, @Value(value="${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}") String apiDocsUrl) throws JsonProcessingException {
        this.calculateServerUrl(request, apiDocsUrl);
        OpenAPI openAPI = this.getOpenApi();
        return Json.mapper().writeValueAsString((Object)openAPI);
    }

    @Operation(hidden=true)
    @GetMapping(value={"/{portal}/api/doc.yml"}, produces={"application/vnd.oai.openapi"})
    public String openapiYaml(HttpServletRequest request, @Value(value="${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}.yaml") String apiDocsUrl) throws JsonProcessingException {
        this.calculateServerUrl(request, apiDocsUrl);
        OpenAPI openAPI = this.getOpenApi();
        return Yaml.mapper().writeValueAsString((Object)openAPI);
    }

    protected void getPaths(Map<String, Object> restControllers) {
        Map map = this.requestMappingHandlerMapping.getHandlerMethods();
        this.calculatePath(restControllers, map, Optional.empty());
        if (this.servletContextProvider.isPresent()) {
            map = this.servletContextProvider.get().getMethods();
            this.calculatePath(restControllers, map, this.servletContextProvider);
        }
        if (this.springSecurityOAuth2Provider.isPresent()) {
            SecurityOAuth2Provider securityOAuth2Provider = this.springSecurityOAuth2Provider.get();
            Map mapOauth = securityOAuth2Provider.getHandlerMethods();
            Map requestMappingMapSec = securityOAuth2Provider.getFrameworkEndpoints();
            Class[] additionalRestClasses = (Class[])requestMappingMapSec.values().stream().map(Object::getClass).toArray(Class[]::new);
            AbstractOpenApiResource.addRestControllers((Class[])additionalRestClasses);
            this.calculatePath(requestMappingMapSec, mapOauth, Optional.empty());
        }
    }

    protected void calculatePath(Map<String, Object> restControllers, Map<RequestMappingInfo, HandlerMethod> map, Optional<ActuatorProvider> actuatorProvider) {
        for (Map.Entry<RequestMappingInfo, HandlerMethod> entry : map.entrySet()) {
            RequestMappingInfo requestMappingInfo = entry.getKey();
            HandlerMethod handlerMethod = entry.getValue();
            PatternsRequestCondition patternsRequestCondition = requestMappingInfo.getPatternsCondition();
            Set patterns = patternsRequestCondition.getPatterns();
            LinkedHashMap regexMap = new LinkedHashMap();
            for (String pattern : patterns) {
                String operationPath = PathUtils.parsePath((String)pattern, regexMap).replace("/{portal}/api", "");
                if ((!actuatorProvider.isPresent() || !actuatorProvider.get().isRestController(operationPath, handlerMethod.getClass())) && !this.isRestController(restControllers, handlerMethod, operationPath) || !this.isPackageToScan(handlerMethod.getBeanType().getPackage()) || !this.isPathToMatch(operationPath)) continue;
                Set requestMethods = requestMappingInfo.getMethodsCondition().getMethods();
                if (requestMethods.isEmpty()) {
                    requestMethods = this.getDefaultAllowedHttpMethods();
                }
                this.calculatePath(handlerMethod, operationPath, requestMethods);
            }
        }
    }

    protected boolean isRestController(Map<String, Object> restControllers, HandlerMethod handlerMethod, String operationPath) {
        return !(!restControllers.containsKey(handlerMethod.getBean().toString()) && !this.isAdditionalRestController(handlerMethod.getBeanType()) || !operationPath.startsWith("/") || !this.springDocConfigProperties.isModelAndViewAllowed() && ModelAndView.class.isAssignableFrom(handlerMethod.getMethod().getReturnType()));
    }

    protected void calculateServerUrl(HttpServletRequest request, String apiDocsUrl) {
        String requestUrl = this.decode(request.getRequestURL().toString());
        String calculatedUrl = requestUrl.substring(0, requestUrl.length() - apiDocsUrl.length());
        this.openAPIService.setServerBaseUrl(calculatedUrl);
    }
}

