/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.transform.transforms.pivot;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import org.elasticsearch.client.transform.transforms.pivot.SingleGroupSource;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;

public class DateHistogramGroupSource
extends SingleGroupSource
implements ToXContentObject {
    private static final ParseField TIME_ZONE = new ParseField("time_zone", new String[0]);
    private static final Set<String> DATE_FIELD_UNITS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("year", "1y", "quarter", "1q", "month", "1M", "week", "1w", "day", "1d", "hour", "1h", "minute", "1m", "second", "1s")));
    private static final ConstructingObjectParser<DateHistogramGroupSource, Void> PARSER = new ConstructingObjectParser("date_histogram_group_source", true, args -> {
        String field = (String)args[0];
        Script script = (Script)args[1];
        boolean missingBucket = args[2] == null ? false : (Boolean)args[2];
        String fixedInterval = (String)args[3];
        String calendarInterval = (String)args[4];
        ZoneId zoneId = (ZoneId)args[5];
        Interval interval = null;
        if (fixedInterval != null && calendarInterval != null) {
            throw new IllegalArgumentException("You must specify either fixed_interval or calendar_interval, found both");
        }
        if (fixedInterval != null) {
            interval = new FixedInterval(new DateHistogramInterval(fixedInterval));
        } else if (calendarInterval != null) {
            interval = new CalendarInterval(new DateHistogramInterval(calendarInterval));
        } else {
            throw new IllegalArgumentException("You must specify either fixed_interval or calendar_interval, found none");
        }
        return new DateHistogramGroupSource(field, script, missingBucket, interval, zoneId);
    });
    private final Interval interval;
    private final ZoneId timeZone;

    public static DateHistogramGroupSource fromXContent(XContentParser parser) {
        return (DateHistogramGroupSource)PARSER.apply(parser, null);
    }

    DateHistogramGroupSource(String field, Script script, Interval interval, ZoneId timeZone) {
        this(field, script, false, interval, timeZone);
    }

    DateHistogramGroupSource(String field, Script script, boolean missingBucket, Interval interval, ZoneId timeZone) {
        super(field, script, missingBucket);
        this.interval = interval;
        this.timeZone = timeZone;
    }

    @Override
    public SingleGroupSource.Type getType() {
        return SingleGroupSource.Type.DATE_HISTOGRAM;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        super.innerXContent(builder, params);
        this.interval.toXContent(builder, params);
        if (this.timeZone != null) {
            builder.field(TIME_ZONE.getPreferredName(), this.timeZone.toString());
        }
        builder.endObject();
        return builder;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DateHistogramGroupSource that = (DateHistogramGroupSource)other;
        return this.missingBucket == that.missingBucket && Objects.equals(this.field, that.field) && Objects.equals(this.script, that.script) && Objects.equals(this.interval, that.interval) && Objects.equals(this.timeZone, that.timeZone);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.script, this.missingBucket, this.interval, this.timeZone);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), FIELD);
        Script.declareScript(PARSER, (BiConsumer)ConstructingObjectParser.optionalConstructorArg(), (ParseField)SCRIPT);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), MISSING_BUCKET);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("fixed_interval", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("calendar_interval", new String[0]));
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return ZoneId.of(p.text());
            }
            return ZoneOffset.ofHours(p.intValue());
        }, TIME_ZONE, ObjectParser.ValueType.LONG);
    }

    public static class CalendarInterval
    implements Interval {
        private static final String NAME = "calendar_interval";
        private final DateHistogramInterval interval;

        public CalendarInterval(DateHistogramInterval interval) {
            this.interval = interval;
            if (!DATE_FIELD_UNITS.contains(interval.toString())) {
                throw new IllegalArgumentException("The supplied interval [" + interval + "] could not be parsed as a calendar interval.");
            }
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public DateHistogramInterval getInterval() {
            return this.interval;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(NAME);
            this.interval.toXContent(builder, params);
            return builder;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            CalendarInterval that = (CalendarInterval)other;
            return Objects.equals(this.interval, that.interval);
        }

        public int hashCode() {
            return Objects.hash(this.interval);
        }
    }

    public static class FixedInterval
    implements Interval {
        private static final String NAME = "fixed_interval";
        private final DateHistogramInterval interval;

        public FixedInterval(DateHistogramInterval interval) {
            this.interval = interval;
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public DateHistogramInterval getInterval() {
            return this.interval;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(NAME);
            this.interval.toXContent(builder, params);
            return builder;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            FixedInterval that = (FixedInterval)other;
            return Objects.equals(this.interval, that.interval);
        }

        public int hashCode() {
            return Objects.hash(this.interval);
        }
    }

    public static interface Interval
    extends ToXContentFragment {
        public String getName();

        public DateHistogramInterval getInterval();
    }

    public static class Builder {
        private String field;
        private Script script;
        private Interval interval;
        private ZoneId timeZone;
        private boolean missingBucket;

        public Builder setField(String field) {
            this.field = field;
            return this;
        }

        public Builder setScript(Script script) {
            this.script = script;
            return this;
        }

        public Builder setInterval(Interval interval) {
            this.interval = interval;
            return this;
        }

        public Builder setTimeZone(ZoneId timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public Builder setMissingBucket(boolean missingBucket) {
            this.missingBucket = missingBucket;
            return this;
        }

        public DateHistogramGroupSource build() {
            return new DateHistogramGroupSource(this.field, this.script, this.missingBucket, this.interval, this.timeZone);
        }
    }
}

