/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.web;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.utils.Log;

public class XFrameOptionsFilter
implements Filter {
    private static String MODE_DENY = "DENY";
    private static String MODE_SAMEORIGIN = "SAMEORIGIN";
    private static String MODE_ALLOWFROM = "ALLOW-FROM";
    private String mode;
    private String url;
    private String domain;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.mode = filterConfig.getInitParameter("mode");
        this.url = filterConfig.getInitParameter("url");
        if (!(this.mode.equals(MODE_DENY) || this.mode.equals(MODE_SAMEORIGIN) || this.mode.equals(MODE_ALLOWFROM))) {
            this.mode = MODE_DENY;
        }
        if (this.mode.equals(MODE_ALLOWFROM)) {
            if (StringUtils.isEmpty((String)this.url)) {
                Log.info((String)"geonetwork", (Object)"XFrameOptions filter url parameter is missing for mode ALLOW-FROM. Setting mode to DENY.");
                this.mode = MODE_DENY;
            } else {
                try {
                    URL urlValue = new URL(this.url);
                    this.domain = urlValue.getHost() + (urlValue.getPort() == -1 ? "" : ":" + urlValue.getPort());
                }
                catch (MalformedURLException ex) {
                    Log.info((String)"geonetwork", (Object)String.format("XFrameOptions filter url parameter (%s) is not valid for mode ALLOW-FROM. Setting mode to DENY.", this.url));
                    this.mode = MODE_DENY;
                }
            }
        }
        if (Log.isDebugEnabled((String)"geonetwork")) {
            Log.debug((String)"geonetwork", (Object)String.format("XFrameOptions filter initialized. Using mode %s.", this.getXFrameOptionsValue()));
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        response.addHeader("X-Frame-Options", this.getXFrameOptionsValue());
        response.addHeader("Content-Security-Policy", this.getContentSecurityPolicyFramAncestorsValue());
        filterChain.doFilter(servletRequest, (ServletResponse)response);
    }

    public void destroy() {
    }

    private String getXFrameOptionsValue() {
        if (this.mode.equals(MODE_ALLOWFROM)) {
            return this.mode + " " + this.url;
        }
        return this.mode;
    }

    private String getContentSecurityPolicyFramAncestorsValue() {
        if (this.mode.equals(MODE_SAMEORIGIN)) {
            return "frame-ancestors 'self'";
        }
        if (this.mode.equals(MODE_ALLOWFROM)) {
            return "frame-ancestors " + this.domain;
        }
        return "frame-ancestors 'none'";
    }
}

