/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.datamanager;

import com.google.common.base.Optional;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.MetadataSourceInfo;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.repository.SimpleMetadata;
import org.fao.geonet.repository.reports.MetadataReportsQueries;
import org.jdom.Element;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;

public interface IMetadataUtils {
    public void init(ServiceContext var1, Boolean var2) throws Exception;

    public String getMetadataUuid(String var1) throws Exception;

    public Integer startEditingSession(ServiceContext var1, String var2) throws Exception;

    public void cancelEditingSession(ServiceContext var1, String var2) throws Exception;

    public void endEditingSession(String var1, UserSession var2);

    public Element enumerateTree(Element var1) throws Exception;

    public String extractUUID(String var1, Element var2) throws Exception;

    public String extractDefaultLanguage(String var1, Element var2) throws Exception;

    public LinkedHashMap<String, String> extractTitles(String var1, Element var2) throws Exception;

    public LinkedHashMap<String, String> extractTitles(@Nonnull String var1) throws Exception;

    public String extractDateModified(String var1, Element var2) throws Exception;

    public Element setUUID(String var1, String var2, Element var3) throws Exception;

    public Element extractSummary(Element var1) throws Exception;

    public String getMetadataId(String var1) throws Exception;

    public String getVersion(String var1);

    public String getNewVersion(String var1);

    public void setTemplateExt(int var1, MetadataType var2) throws Exception;

    public void setTemplate(int var1, MetadataType var2, String var3) throws Exception;

    public void setHarvestedExt(int var1, String var2) throws Exception;

    public void setHarvested(int var1, String var2) throws Exception;

    public void setHarvestedExt(int var1, String var2, Optional<String> var3) throws Exception;

    public void updateDisplayOrder(String var1, String var2) throws Exception;

    public void increasePopularity(ServiceContext var1, String var2) throws Exception;

    public int rateMetadata(int var1, String var2, int var3) throws Exception;

    public Element getMetadataNoInfo(ServiceContext var1, String var2) throws Exception;

    public Element removeMetadataInfo(Element var1) throws Exception;

    public Element getElementByRef(Element var1, String var2);

    public boolean existsMetadataUuid(String var1) throws Exception;

    public boolean existsMetadata(int var1) throws Exception;

    public boolean isMetadataPublished(int var1) throws Exception;

    public boolean isMetadataApproved(int var1) throws Exception;

    public boolean isMetadataDraft(int var1) throws Exception;

    public Element getKeywords() throws Exception;

    public void setDataCommons(ServiceContext var1, String var2, String var3, String var4, String var5, String var6, String var7) throws Exception;

    public void setCreativeCommons(ServiceContext var1, String var2, String var3, String var4, String var5, String var6, String var7) throws Exception;

    public void setMetadataManager(IMetadataManager var1);

    public String getMetadataTitle(String var1) throws Exception;

    public void setSubtemplateTypeAndTitleExt(int var1, String var2) throws Exception;

    public long count(Specification<? extends AbstractMetadata> var1);

    public AbstractMetadata findOne(int var1);

    public List<Integer> findAllIdsBy(Specification<? extends AbstractMetadata> var1);

    public long count();

    public AbstractMetadata findOneByUuid(String var1);

    public List<? extends AbstractMetadata> findAllByUuid(String var1);

    public AbstractMetadata findOne(Specification<? extends AbstractMetadata> var1);

    public AbstractMetadata findOne(String var1);

    @Nonnull
    public List<? extends AbstractMetadata> findAllByHarvestInfo_Uuid(@Nonnull String var1);

    public Iterable<? extends AbstractMetadata> findAll(Set<Integer> var1);

    public List<? extends AbstractMetadata> findAll(Specification<? extends AbstractMetadata> var1, Sort var2);

    public List<? extends AbstractMetadata> findAll(Specification<? extends AbstractMetadata> var1);

    public List<SimpleMetadata> findAllSimple(String var1);

    public boolean exists(Integer var1);

    @Nonnull
    public Element findAllAsXml(Specification<? extends AbstractMetadata> var1, Sort var2);

    @Nonnull
    public Element findAllAsXml(@Nullable Specification<? extends AbstractMetadata> var1, @Nullable Pageable var2);

    public MetadataReportsQueries getMetadataReports();

    public boolean checkMetadataWithSameUuidExist(String var1, int var2);

    @Nonnull
    public Page<Pair<Integer, ISODate>> findAllIdsAndChangeDates(@Nonnull Pageable var1);

    public Map<Integer, MetadataSourceInfo> findAllSourceInfo(Specification<? extends AbstractMetadata> var1);

    public void cloneFiles(AbstractMetadata var1, AbstractMetadata var2);

    public void replaceFiles(AbstractMetadata var1, AbstractMetadata var2);
}

