/*
 * Decompiled with CFR 0.152.
 */
package jeeves.server.dispatchers.guiservices;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.ServletContext;
import jeeves.XmlFileCacher;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.utils.Log;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.springframework.context.ApplicationContext;

public class XmlCacheManager {
    WeakHashMap<String, Map<String, XmlFileCacher>> xmlCaches = new WeakHashMap();

    private Map<String, XmlFileCacher> getCacheMap(boolean localized, Path base, String file) {
        String key = localized + ":" + base + ":" + file;
        Map<String, XmlFileCacher> cacheMap = this.xmlCaches.get(key);
        if (cacheMap == null) {
            cacheMap = new HashMap<String, XmlFileCacher>(10);
            this.xmlCaches.put(key, cacheMap);
        }
        return cacheMap;
    }

    public synchronized Element get(ApplicationContext context, boolean localized, Path base, String file, String preferedLanguage, String defaultLang, boolean makeCopy) throws JDOMException, IOException {
        Element result;
        Path xmlFilePath;
        Path rootPath;
        Map<String, XmlFileCacher> cacheMap = this.getCacheMap(localized, base, file);
        Path appPath = ((GeonetworkDataDirectory)context.getBean(GeonetworkDataDirectory.class)).getWebappDir();
        boolean isBaseAbsolutePath = base.isAbsolute();
        Path path = rootPath = isBaseAbsolutePath ? base : appPath.resolve(base);
        if (localized) {
            xmlFilePath = rootPath.resolve(preferedLanguage).resolve(file);
        } else {
            xmlFilePath = rootPath.resolve(file);
            if (!Files.exists(xmlFilePath, new LinkOption[0])) {
                xmlFilePath = appPath.resolve(file);
            }
        }
        ServletContext servletContext = (ServletContext)context.getBean(ServletContext.class);
        XmlFileCacher xmlCache = cacheMap.get(preferedLanguage);
        Path xmlFile = xmlFilePath;
        if (xmlCache == null) {
            xmlCache = new XmlFileCacher(xmlFile, servletContext, appPath);
            cacheMap.put(preferedLanguage, xmlCache);
        }
        try {
            if (!makeCopy) {
                return xmlCache.get();
            }
            result = (Element)xmlCache.get().clone();
        }
        catch (Exception e) {
            Log.debug((String)"jeeves.resources", (Object)("Error cloning the cached data.  Attempted to get: " + xmlFilePath + " but failed so falling back to default language"), (Exception)e);
            Path xmlDefaultLangFilePath = rootPath.resolve(defaultLang).resolve(file);
            xmlCache = new XmlFileCacher(xmlDefaultLangFilePath, servletContext, appPath);
            cacheMap.put(preferedLanguage, xmlCache);
            result = (Element)xmlCache.get().clone();
        }
        String name = com.google.common.io.Files.getNameWithoutExtension((String)xmlFile.getFileName().toString());
        return result.setName(name);
    }
}

