/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.compiler.expressions.GuardValue;
import com.github.sommeri.less4j.core.compiler.stages.BodyCompilationResult;
import com.github.sommeri.less4j.core.problems.BugHappened;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DefaultGuardHelper {
    private final ProblemsHandler problemsHandler;

    public DefaultGuardHelper(ProblemsHandler problemsHandler) {
        this.problemsHandler = problemsHandler;
    }

    public List<BodyCompilationResult> chooseMixinsToBeUsed(List<BodyCompilationResult> compiledMixins, MixinReference reference) {
        int ifDefaultCnt;
        int ifNotCnt;
        int normalMixinsCnt = ArraysUtils.count(compiledMixins, GuardValue.USE.filter());
        if (normalMixinsCnt + (ifNotCnt = ArraysUtils.count(compiledMixins, GuardValue.USE_IF_NOT_DEFAULT.filter())) + (ifDefaultCnt = ArraysUtils.count(compiledMixins, GuardValue.USE_IF_DEFAULT.filter())) != compiledMixins.size()) {
            throw new BugHappened("Unexpected mixin type in compiled mixins list.", (ASTCssNode)reference);
        }
        if (normalMixinsCnt > 0) {
            return this.keepOnly(compiledMixins, GuardValue.USE, GuardValue.USE_IF_NOT_DEFAULT);
        }
        if (ifDefaultCnt + ifNotCnt > 1) {
            List<BodyCompilationResult> errorSet = this.keepOnly(compiledMixins, GuardValue.USE_IF_DEFAULT, GuardValue.USE_IF_NOT_DEFAULT);
            this.problemsHandler.ambiguousDefaultSet(reference, this.extractOriginalMixins(errorSet));
            return Collections.emptyList();
        }
        return this.keepOnly(compiledMixins, GuardValue.USE_IF_DEFAULT);
    }

    private List<BodyCompilationResult> keepOnly(List<BodyCompilationResult> compiledMixins, GuardValue ... kind) {
        Set<GuardValue> expectedUses = ArraysUtils.asSet(kind);
        Iterator<BodyCompilationResult> iterator = compiledMixins.iterator();
        while (iterator.hasNext()) {
            BodyCompilationResult compiled = iterator.next();
            if (expectedUses.contains((Object)compiled.getGuardValue())) continue;
            iterator.remove();
        }
        return compiledMixins;
    }

    private List<ASTCssNode> extractOriginalMixins(List<BodyCompilationResult> compiledMixins) {
        ArrayList<ASTCssNode> result = new ArrayList<ASTCssNode>();
        for (BodyCompilationResult compiled : compiledMixins) {
            result.add(compiled.getCompiledBodyOwner());
        }
        return result;
    }
}

