/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.binders;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.Date;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.cloudwatch.domain.MetricDatum;
import org.jclouds.cloudwatch.domain.StatisticValues;
import org.jclouds.date.DateService;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Beta
public class MetricDataBinder
implements Binder {
    private final DateService dateService;

    @Inject
    protected MetricDataBinder(DateService dateService) {
        this.dateService = dateService;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Iterable metrics = (Iterable)Preconditions.checkNotNull((Object)input, (Object)"metrics must be set!");
        ImmutableMultimap.Builder formParameters = ImmutableMultimap.builder();
        int metricDatumIndex = 1;
        for (MetricDatum metricDatum : metrics) {
            int dimensionIndex = 1;
            for (Dimension dimension : metricDatum.getDimensions()) {
                formParameters.put((Object)("MetricData.member." + metricDatumIndex + ".Dimensions.member." + dimensionIndex + ".Name"), (Object)dimension.getName());
                formParameters.put((Object)("MetricData.member." + metricDatumIndex + ".Dimensions.member." + dimensionIndex + ".Value"), (Object)dimension.getValue());
                ++dimensionIndex;
            }
            formParameters.put((Object)("MetricData.member." + metricDatumIndex + ".MetricName"), (Object)metricDatum.getMetricName());
            if (metricDatum.getStatisticValues().isPresent()) {
                StatisticValues statisticValues = (StatisticValues)metricDatum.getStatisticValues().get();
                formParameters.put((Object)("MetricData.member." + metricDatumIndex + ".StatisticValues.Maximum"), (Object)String.valueOf(statisticValues.getMaximum()));
                formParameters.put((Object)("MetricData.member." + metricDatumIndex + ".StatisticValues.Minimum"), (Object)String.valueOf(statisticValues.getMinimum()));
                formParameters.put((Object)("MetricData.member." + metricDatumIndex + ".StatisticValues.SampleCount"), (Object)String.valueOf(statisticValues.getSampleCount()));
                formParameters.put((Object)("MetricData.member." + metricDatumIndex + ".StatisticValues.Sum"), (Object)String.valueOf(statisticValues.getSum()));
            }
            if (metricDatum.getTimestamp().isPresent()) {
                formParameters.put((Object)("MetricData.member." + metricDatumIndex + ".Timestamp"), (Object)this.dateService.iso8601SecondsDateFormat((Date)metricDatum.getTimestamp().get()));
            }
            formParameters.put((Object)("MetricData.member." + metricDatumIndex + ".Unit"), (Object)String.valueOf((Object)metricDatum.getUnit()));
            if (metricDatum.getValue().isPresent()) {
                formParameters.put((Object)("MetricData.member." + metricDatumIndex + ".Value"), (Object)String.valueOf(metricDatum.getValue().get()));
            }
            ++metricDatumIndex;
        }
        return (R)request.toBuilder().replaceFormParams((Multimap)formParameters.build()).build();
    }
}

