/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.domain;

import org.jclouds.aws.ec2.domain.AutoValue_Route;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class Route {
    @Nullable
    public abstract String destinationCidrBlock();

    @Nullable
    public abstract String gatewayId();

    @Nullable
    public abstract RouteState state();

    @Nullable
    public abstract String origin();

    @SerializedNames(value={"destinationCidrBlock", "gatewayId", "state", "origin"})
    public static Route create(String destinationCidrBlock, String gatewayId, RouteState state, String origin) {
        return Route.builder().destinationCidrBlock(destinationCidrBlock).gatewayId(gatewayId).state(state).origin(origin).build();
    }

    Route() {
    }

    public static Builder builder() {
        return new AutoValue_Route.Builder();
    }

    public static abstract class Builder {
        public abstract Builder destinationCidrBlock(String var1);

        public abstract Builder gatewayId(String var1);

        public abstract Builder state(RouteState var1);

        public abstract Builder origin(String var1);

        public abstract Route build();
    }

    public static enum RouteState {
        ACTIVE,
        BLACKHOLE,
        UNRECOGNIZED;


        public String value() {
            return this.name().toLowerCase();
        }

        public static RouteState fromValue(String v) {
            if (v == null || v.isEmpty()) {
                throw new IllegalArgumentException("Value cannot be null or empty");
            }
            try {
                return RouteState.valueOf(v.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

