/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.security.ShellBasedUnixGroupsMapping;
import org.apache.hadoop.util.ReflectionUtils;

public class Groups {
    private static final Log LOG = LogFactory.getLog(Groups.class);
    private final GroupMappingServiceProvider impl;
    private final Map<String, CachedGroups> userToGroupsMap = new ConcurrentHashMap<String, CachedGroups>();
    private final long cacheTimeout;
    private static Groups GROUPS = null;

    public Groups(Configuration conf) {
        this.impl = ReflectionUtils.newInstance(conf.getClass("hadoop.security.group.mapping", ShellBasedUnixGroupsMapping.class, GroupMappingServiceProvider.class), conf);
        this.cacheTimeout = conf.getLong("hadoop.security.groups.cache.secs", 300L) * 1000L;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Group mapping impl=" + this.impl.getClass().getName() + "; cacheTimeout=" + this.cacheTimeout));
        }
    }

    public List<String> getGroups(String user) throws IOException {
        CachedGroups groups = this.userToGroupsMap.get(user);
        long now = System.currentTimeMillis();
        if (groups != null && groups.getTimestamp() + this.cacheTimeout > now) {
            LOG.debug((Object)("Returning cached groups for '" + user + "'"));
            return groups.getGroups();
        }
        groups = new CachedGroups(this.impl.getGroups(user));
        this.userToGroupsMap.put(user, groups);
        LOG.debug((Object)("Returning fetched groups for '" + user + "'"));
        return groups.getGroups();
    }

    public void refresh() {
        LOG.info((Object)"clearing userToGroupsMap cache");
        try {
            this.impl.cacheGroupsRefresh();
        }
        catch (IOException e) {
            LOG.warn((Object)"Error refreshing groups cache", (Throwable)e);
        }
        this.userToGroupsMap.clear();
    }

    public void cacheGroupsAdd(List<String> groups) {
        try {
            this.impl.cacheGroupsAdd(groups);
        }
        catch (IOException e) {
            LOG.warn((Object)"Error caching groups", (Throwable)e);
        }
    }

    public static Groups getUserToGroupsMappingService() {
        return Groups.getUserToGroupsMappingService(new Configuration());
    }

    public static Groups getUserToGroupsMappingService(Configuration conf) {
        if (GROUPS == null) {
            LOG.debug((Object)" Creating new Groups object");
            GROUPS = new Groups(conf);
        }
        return GROUPS;
    }

    private static class CachedGroups {
        final long timestamp;
        final List<String> groups;

        CachedGroups(List<String> groups) {
            this.groups = groups;
            this.timestamp = System.currentTimeMillis();
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public List<String> getGroups() {
            return this.groups;
        }
    }
}

