/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import java.nio.ByteBuffer;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class PointHandler
implements ShapeHandler {
    final ShapeType shapeType;
    GeometryFactory geometryFactory;

    public PointHandler(ShapeType type, GeometryFactory gf) throws ShapefileException {
        if (type != ShapeType.POINT && type != ShapeType.POINTM && type != ShapeType.POINTZ) {
            throw new ShapefileException("PointHandler constructor: expected a type of 1, 11 or 21");
        }
        this.shapeType = type;
        this.geometryFactory = gf;
    }

    public PointHandler() {
        this.shapeType = ShapeType.POINT;
    }

    @Override
    public ShapeType getShapeType() {
        return this.shapeType;
    }

    @Override
    public int getLength(Object geometry) {
        int length;
        if (this.shapeType == ShapeType.POINT) {
            length = 20;
        } else if (this.shapeType == ShapeType.POINTM) {
            length = 28;
        } else if (this.shapeType == ShapeType.POINTZ) {
            length = 36;
        } else {
            throw new IllegalStateException("Expected ShapeType of Point, got" + this.shapeType);
        }
        return length;
    }

    @Override
    public Object read(ByteBuffer buffer, ShapeType type, boolean flatGeometry) {
        if (type == ShapeType.NULL) {
            return this.createNull();
        }
        Object c = this.shapeType == ShapeType.POINTZ ? new CoordinateXYZM() : (this.shapeType == ShapeType.POINTM ? new CoordinateXYM() : new CoordinateXY());
        c.setX(buffer.getDouble());
        c.setY(buffer.getDouble());
        if (this.shapeType == ShapeType.POINTM) {
            c.setM(buffer.getDouble());
        }
        if (this.shapeType == ShapeType.POINTZ) {
            c.setZ(buffer.getDouble());
            c.setM(buffer.getDouble());
        }
        return this.geometryFactory.createPoint((Coordinate)c);
    }

    private Object createNull() {
        return this.geometryFactory.createPoint(new Coordinate(Double.NaN, Double.NaN, Double.NaN));
    }

    @Override
    public void write(ByteBuffer buffer, Object geometry) {
        Point point = (Point)geometry;
        Coordinate c = point.getCoordinate();
        buffer.putDouble(c.x);
        buffer.putDouble(c.y);
        if (this.shapeType == ShapeType.POINTZ) {
            if (Double.isNaN(c.getZ())) {
                buffer.putDouble(0.0);
            } else {
                buffer.putDouble(c.getZ());
            }
        }
        if (this.shapeType == ShapeType.POINTZ || this.shapeType == ShapeType.POINTM) {
            double m = point.getCoordinateSequence().getM(0);
            buffer.putDouble(!Double.isNaN(m) ? m : 0.0);
        }
    }
}

