/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.hibernate5.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;
import org.jasypt.encryption.pbe.PBEStringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.hibernate5.encryptor.HibernatePBEEncryptorRegistry;

public abstract class AbstractEncryptedAsStringType
implements UserType,
ParameterizedType {
    static final int sqlType = 12;
    static final int[] sqlTypes = new int[]{12};
    private boolean initialized = false;
    private boolean useEncryptorName = false;
    private String encryptorName = null;
    private String algorithm = null;
    private String providerName = null;
    private String password = null;
    private Integer keyObtentionIterations = null;
    private String stringOutputType = null;
    protected PBEStringEncryptor encryptor = null;

    protected abstract Object convertToObject(String var1);

    protected String convertToString(Object object) {
        return object == null ? null : object.toString();
    }

    public final int[] sqlTypes() {
        return (int[])sqlTypes.clone();
    }

    public abstract Class returnedClass();

    public final boolean equals(Object x, Object y) throws HibernateException {
        return x == y || x != null && y != null && x.equals(y);
    }

    public final Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public final Object assemble(Serializable cached, Object owner) throws HibernateException {
        if (cached == null) {
            return null;
        }
        return this.deepCopy(cached);
    }

    public final Serializable disassemble(Object value) throws HibernateException {
        if (value == null) {
            return null;
        }
        return (Serializable)this.deepCopy(value);
    }

    public final boolean isMutable() {
        return false;
    }

    public final int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public final Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws HibernateException, SQLException {
        this.checkInitialization();
        String message = rs.getString(names[0]);
        return rs.wasNull() ? null : this.convertToObject(this.encryptor.decrypt(message));
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        this.checkInitialization();
        if (value == null) {
            st.setNull(index, 12);
        } else {
            st.setString(index, this.encryptor.encrypt(this.convertToString(value)));
        }
    }

    public synchronized void setParameterValues(Properties parameters) {
        String paramEncryptorName = parameters.getProperty("encryptorRegisteredName");
        String paramAlgorithm = parameters.getProperty("algorithm");
        String paramProviderName = parameters.getProperty("providerName");
        String paramPassword = parameters.getProperty("password");
        String paramKeyObtentionIterations = parameters.getProperty("keyObtentionIterations");
        String paramStringOutputType = parameters.getProperty("stringOutputType");
        this.useEncryptorName = false;
        if (paramEncryptorName != null) {
            if (paramAlgorithm != null || paramPassword != null || paramKeyObtentionIterations != null) {
                throw new EncryptionInitializationException("If \"encryptorRegisteredName\" is specified, none of \"algorithm\", \"password\" or \"keyObtentionIterations\" can be specified");
            }
            this.encryptorName = paramEncryptorName;
            this.useEncryptorName = true;
        } else if (paramPassword != null) {
            this.password = paramPassword;
            if (paramAlgorithm != null) {
                this.algorithm = paramAlgorithm;
            }
            if (paramProviderName != null) {
                this.providerName = paramProviderName;
            }
            if (paramKeyObtentionIterations != null) {
                try {
                    this.keyObtentionIterations = new Integer(Integer.parseInt(paramKeyObtentionIterations));
                }
                catch (NumberFormatException e) {
                    throw new EncryptionInitializationException("Value specified for \"keyObtentionIterations\" is not a valid integer");
                }
            }
            if (paramStringOutputType != null) {
                this.stringOutputType = paramStringOutputType;
            }
        } else {
            throw new EncryptionInitializationException("If \"encryptorRegisteredName\" is not specified, then \"password\" (and optionally \"algorithm\" and \"keyObtentionIterations\") must be specified");
        }
    }

    protected final synchronized void checkInitialization() {
        if (!this.initialized) {
            if (this.useEncryptorName) {
                HibernatePBEEncryptorRegistry registry = HibernatePBEEncryptorRegistry.getInstance();
                PBEStringEncryptor pbeEncryptor = registry.getPBEStringEncryptor(this.encryptorName);
                if (pbeEncryptor == null) {
                    throw new EncryptionInitializationException("No string encryptor registered for hibernate with name \"" + this.encryptorName + "\"");
                }
                this.encryptor = pbeEncryptor;
            } else {
                StandardPBEStringEncryptor newEncryptor = new StandardPBEStringEncryptor();
                newEncryptor.setPassword(this.password);
                if (this.algorithm != null) {
                    newEncryptor.setAlgorithm(this.algorithm);
                }
                if (this.providerName != null) {
                    newEncryptor.setProviderName(this.providerName);
                }
                if (this.keyObtentionIterations != null) {
                    newEncryptor.setKeyObtentionIterations(this.keyObtentionIterations.intValue());
                }
                if (this.stringOutputType != null) {
                    newEncryptor.setStringOutputType(this.stringOutputType);
                }
                newEncryptor.initialize();
                this.encryptor = newEncryptor;
            }
            this.initialized = true;
        }
    }
}

