/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;

public class RunListBuilder {
    private List<String> list = Lists.newArrayList();

    public RunListBuilder addRecipe(String recipe) {
        return this.addRecipes((String)Preconditions.checkNotNull((Object)recipe, (Object)"recipe"));
    }

    public RunListBuilder addRecipes(String ... recipes) {
        Iterables.addAll(this.list, (Iterable)Lists.transform(Arrays.asList((Object[])Preconditions.checkNotNull((Object)recipes, (Object)"recipes")), (Function)new Function<String, String>(){

            public String apply(String from) {
                return "recipe[" + from + "]";
            }
        }));
        return this;
    }

    public RunListBuilder addRole(String role) {
        return this.addRoles((String)Preconditions.checkNotNull((Object)role, (Object)"role"));
    }

    public RunListBuilder addRoles(String ... roles) {
        Iterables.addAll(this.list, (Iterable)Lists.transform(Arrays.asList((Object[])Preconditions.checkNotNull((Object)roles, (Object)"roles")), (Function)new Function<String, String>(){

            public String apply(String from) {
                return "role[" + from + "]";
            }
        }));
        return this;
    }

    public List<String> build() {
        return ImmutableList.copyOf(this.list);
    }
}

