/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.PlanarImage;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.image.util.ImageUtilities;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.processing.OperationNotFoundException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.InternationalString;

public abstract class BaseScaleOperationJAI
extends OperationJAI {
    public static final String AFFINE = "Affine";
    public static final String SCALE = "Scale";
    public static final String TRANSLATE = "Translate";
    public static final String WARP = "Warp";
    public static final String ROI = "roi";
    private static final long serialVersionUID = 1L;

    public BaseScaleOperationJAI(String operation) throws OperationNotFoundException {
        super(operation);
    }

    public BaseScaleOperationJAI(OperationDescriptor operation) {
        super(operation);
    }

    public BaseScaleOperationJAI(OperationDescriptor operation, ParameterDescriptorGroup descriptor) {
        super(operation, descriptor);
    }

    @Override
    protected GridCoverage2D deriveGridCoverage(GridCoverage2D[] sources, OperationJAI.Parameters parameters) {
        MathTransform finalTransform;
        ImageLayout layout;
        Object targetHints;
        int indexOfBorderExtenderParam;
        try {
            indexOfBorderExtenderParam = parameters.parameters.indexOfParam("BorderExtender");
        }
        catch (IllegalArgumentException e) {
            indexOfBorderExtenderParam = -1;
        }
        BorderExtender borderExtender = indexOfBorderExtenderParam != -1 ? parameters.parameters.getObjectParameter("BorderExtender") : ImageUtilities.DEFAULT_BORDER_EXTENDER;
        GridCoverage2D sourceCoverage = sources[0];
        RenderedImage sourceImage = sourceCoverage.getRenderedImage();
        Object object = targetHints = parameters.hints != null ? parameters.hints : ImageUtilities.getRenderingHints(sourceImage);
        if (targetHints == null) {
            targetHints = new RenderingHints(null);
        }
        if (parameters.hints != null) {
            ((RenderingHints)targetHints).add((RenderingHints)parameters.hints);
        }
        if ((layout = (ImageLayout)((RenderingHints)targetHints).get(JAI.KEY_IMAGE_LAYOUT)) != null) {
            layout = (ImageLayout)layout.clone();
        } else {
            layout = new ImageLayout(sourceImage);
            layout.unsetTileLayout();
        }
        if ((layout.getValidMask() & 0xF0) == 0) {
            layout.setTileGridXOffset(layout.getMinX(sourceImage));
            layout.setTileGridYOffset(layout.getMinY(sourceImage));
            int width = layout.getWidth(sourceImage);
            int height = layout.getHeight(sourceImage);
            if (layout.getTileWidth(sourceImage) > width) {
                layout.setTileWidth(width);
            }
            if (layout.getTileHeight(sourceImage) > height) {
                layout.setTileHeight(height);
            }
        }
        ((RenderingHints)targetHints).put(JAI.KEY_IMAGE_LAYOUT, layout);
        ((RenderingHints)targetHints).put(JAI.KEY_BORDER_EXTENDER, borderExtender);
        boolean asPhotographicStrategy = sourceImage.getColorModel() instanceof IndexColorModel;
        if (!asPhotographicStrategy) {
            ((RenderingHints)targetHints).add(ImageUtilities.DONT_REPLACE_INDEX_COLOR_MODEL);
        } else {
            ((RenderingHints)targetHints).add(ImageUtilities.REPLACE_INDEX_COLOR_MODEL);
            layout.unsetValid(512);
            layout.unsetValid(256);
        }
        RenderedImage image = this.createRenderedImage(parameters.parameters, (RenderingHints)targetHints);
        double scaleX = (double)image.getWidth() / (1.0 * (double)sourceImage.getWidth());
        double scaleY = (double)image.getHeight() / (1.0 * (double)sourceImage.getHeight());
        double tX = (double)image.getMinX() - (double)sourceImage.getMinX() * scaleX;
        double tY = (double)image.getMinY() - (double)sourceImage.getMinY() * scaleY;
        AffineTransform scaleTranslate = new AffineTransform(scaleX, 0.0, 0.0, scaleY, tX, tY);
        try {
            scaleTranslate.invert();
            scaleTranslate.preConcatenate(CoverageUtilities.CENTER_TO_CORNER);
            AffineTransform2D tr = new AffineTransform2D(scaleTranslate);
            finalTransform = ConcatenatedTransform.create(tr, (MathTransform)sourceCoverage.getGridGeometry().getGridToCRS2D());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        InternationalString name = this.deriveName(sources, 0, parameters);
        Map<String, ?> properties = this.getProperties(image, parameters.crs, name, finalTransform, sources, parameters);
        GridGeometry2D gg2D = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(PlanarImage.wrapRenderedImage((RenderedImage)image).getBounds()), PixelInCell.CELL_CORNER, finalTransform, parameters.crs, null);
        GridCoverage2D result = BaseScaleOperationJAI.getFactory(parameters.hints).create((CharSequence)name, image, gg2D, asPhotographicStrategy ? null : (GridSampleDimension[])sourceCoverage.getSampleDimensions().clone(), (GridCoverage[])sources, properties);
        return result;
    }
}

