/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.impl;

import java.awt.RenderingHints;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.geotools.data.DataAccess;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.ResourceInfo;
import org.geotools.data.wfs.impl.WFSContentDataAccess;
import org.geotools.data.wfs.internal.GetFeatureRequest;
import org.geotools.data.wfs.internal.WFSClient;
import org.geotools.data.wfs.internal.WFSContentComplexFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WFSContentComplexFeatureSource
implements FeatureSource<FeatureType, Feature> {
    private Name typeName;
    private WFSClient client;
    private WFSContentDataAccess dataAccess;

    public WFSContentComplexFeatureSource(Name typeName, WFSClient client, WFSContentDataAccess dataAccess) {
        this.typeName = typeName;
        this.client = client;
        this.dataAccess = dataAccess;
    }

    public FeatureCollection<FeatureType, Feature> getFeatures(Filter filter) throws IOException {
        return this.getFeatures(new Query(this.typeName.toString(), filter));
    }

    public FeatureCollection<FeatureType, Feature> getFeatures() throws IOException {
        return this.getFeatures(Query.ALL);
    }

    public FeatureCollection<FeatureType, Feature> getFeatures(Query query) throws IOException {
        GetFeatureRequest request = this.client.createGetFeatureRequest();
        FeatureType schema = this.dataAccess.getSchema(this.typeName);
        QName name = this.dataAccess.getRemoteTypeName(this.typeName);
        request.setTypeName(new QName(query.getTypeName()));
        request.setFullType(schema);
        request.setFilter(query.getFilter());
        request.setPropertyNames(query.getPropertyNames());
        request.setSortBy(query.getSortBy());
        String srsName = null;
        request.setSrsName(srsName);
        return new WFSContentComplexFeatureCollection(request, schema, name);
    }

    public Name getName() {
        return this.typeName;
    }

    public ResourceInfo getInfo() {
        return new ResourceInfo(){
            final Set<String> words = new HashSet<String>();
            {
                this.words.add("features");
                this.words.add(WFSContentComplexFeatureSource.this.getName().getURI());
            }

            public ReferencedEnvelope getBounds() {
                try {
                    return WFSContentComplexFeatureSource.this.getBounds();
                }
                catch (IOException e) {
                    return null;
                }
            }

            public CoordinateReferenceSystem getCRS() {
                return WFSContentComplexFeatureSource.this.getSchema().getCoordinateReferenceSystem();
            }

            public String getDescription() {
                return null;
            }

            public Set<String> getKeywords() {
                return this.words;
            }

            public String getName() {
                return WFSContentComplexFeatureSource.this.getName().getURI();
            }

            public URI getSchema() {
                Name name = WFSContentComplexFeatureSource.this.getSchema().getName();
                try {
                    URI namespace = new URI(name.getNamespaceURI());
                    return namespace;
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }

            public String getTitle() {
                Name name = WFSContentComplexFeatureSource.this.getSchema().getName();
                return name.getLocalPart();
            }
        };
    }

    public DataAccess<FeatureType, Feature> getDataStore() {
        return this.dataAccess;
    }

    public QueryCapabilities getQueryCapabilities() {
        return new QueryCapabilities();
    }

    public void addFeatureListener(FeatureListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeFeatureListener(FeatureListener listener) {
        throw new UnsupportedOperationException();
    }

    public FeatureType getSchema() {
        try {
            return this.dataAccess.getSchema(this.typeName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ReferencedEnvelope getBounds() throws IOException {
        return this.dataAccess.getFeatureSource(this.typeName).getBounds();
    }

    public ReferencedEnvelope getBounds(Query query) throws IOException {
        return this.dataAccess.getFeatureSource(this.typeName).getBounds(query);
    }

    public int getCount(Query query) throws IOException {
        return this.getFeatures(query).size();
    }

    public Set<RenderingHints.Key> getSupportedHints() {
        return Collections.emptySet();
    }
}

