/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.binders;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;
import org.jclouds.rest.binders.BindAsHostPrefix;

@Singleton
public class BindAsHostPrefixIfConfigured
implements Binder {
    protected final BindAsHostPrefix bindAsHostPrefix;
    protected final boolean isVhostStyle;
    protected final String servicePath;

    @Inject
    public BindAsHostPrefixIfConfigured(BindAsHostPrefix bindAsHostPrefix, @Named(value="jclouds.s3.virtual-host-buckets") boolean isVhostStyle, @Named(value="jclouds.s3.service-path") String servicePath) {
        this.bindAsHostPrefix = bindAsHostPrefix;
        this.isVhostStyle = isVhostStyle;
        this.servicePath = servicePath;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        String payloadAsString = payload.toString();
        if (this.isVhostStyle && payloadAsString.equals(payloadAsString.toLowerCase())) {
            request = this.bindAsHostPrefix.bindToRequest(request, payload);
            String host = request.getEndpoint().getHost();
            if (request.getEndpoint().getPort() != -1) {
                host = host + ":" + request.getEndpoint().getPort();
            }
            return (R)((HttpRequest.Builder)request.toBuilder().replaceHeader("Host", new String[]{host})).build();
        }
        StringBuilder path = new StringBuilder(request.getEndpoint().getRawPath());
        if (this.servicePath.equals("/")) {
            if (path.toString().equals("/")) {
                path.append(payloadAsString);
            } else {
                path.insert(0, "/" + payloadAsString);
            }
        } else {
            int indexToInsert = 0;
            indexToInsert = path.indexOf(this.servicePath);
            indexToInsert = indexToInsert == -1 ? 0 : indexToInsert;
            path.insert(indexToInsert += this.servicePath.length(), "/" + payloadAsString);
        }
        return (R)request.toBuilder().replacePath(path.toString()).build();
    }
}

