/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.features;

import java.io.Closeable;
import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.WrapWith;
import org.jclouds.softlayer.domain.Network;
import org.jclouds.softlayer.domain.Subnet;

@RequestFilters(value={BasicAuthentication.class})
@Path(value="/v{jclouds.api-version}")
@Consumes(value={"application/json"})
public interface NetworkApi
extends Closeable {
    public static final String NAME_MASK = "mask.subnets";

    @GET
    @Named(value="Network:getAlllObjects")
    @Path(value="/SoftLayer_Network/getAllObjects")
    @Produces(value={"application/json"})
    @QueryParams(keys={"objectMask"}, values={"mask.subnets"})
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<Network> listNetworks();

    @GET
    @Named(value="Network:getName")
    @Path(value="/SoftLayer_Network/{id}/getName")
    @Produces(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public String getName(@PathParam(value="id") long var1);

    @GET
    @Named(value="Network:getNotes")
    @Path(value="/SoftLayer_Network/{id}/getNotes")
    @Produces(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public String getNotes(@PathParam(value="id") long var1);

    @GET
    @Named(value="Network:getObject")
    @Path(value="/SoftLayer_Network/{id}/getObject")
    @Produces(value={"application/json"})
    @QueryParams(keys={"objectMask"}, values={"mask.subnets"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Network getNetwork(@PathParam(value="id") long var1);

    @GET
    @Named(value="Network:getSubnets")
    @Path(value="/SoftLayer_Network/{id}/getSubnets")
    @Produces(value={"application/json"})
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<Subnet> getSubnets(@PathParam(value="id") long var1);

    @POST
    @Named(value="network:createObject")
    @Path(value="/SoftLayer_Network/createObject")
    @Produces(value={"application/json"})
    public Network createNetwork(@WrapWith(value="parameters") List<Network.CreateNetwork> var1);

    @PUT
    @Named(value="Network:editObject")
    @Path(value="/SoftLayer_Network/{id}/editObject")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean editNetwork(@PathParam(value="id") long var1, @WrapWith(value="parameters") List<Network.EditNetwork> var3);

    @DELETE
    @Named(value="network:deleteObject")
    @Path(value="/SoftLayer_Network/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteNetwork(@PathParam(value="id") long var1);

    @POST
    @Named(value="Network:createSubnet")
    @Path(value="/SoftLayer_Network/{id}/createSubnet")
    @Produces(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Subnet createSubnet(@PathParam(value="id") long var1, @WrapWith(value="parameters") List<Object> var3);

    @POST
    @Named(value="Network:deleteSubnet")
    @Path(value="/SoftLayer_Network/{id}/deleteSubnet")
    @Produces(value={"application/json"})
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteSubnet(@PathParam(value="id") long var1, @WrapWith(value="parameters") List<Subnet.DeleteSubnet> var3);
}

