/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.softlayer.domain.Address;
import org.jclouds.softlayer.domain.Region;

public class Datacenter {
    private final int id;
    private final String name;
    private final String longName;
    private final Address locationAddress;
    private final Set<Region> regions;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromDatacenter(this);
    }

    @ConstructorProperties(value={"id", "name", "longName", "locationAddress", "regions"})
    protected Datacenter(int id, @Nullable String name, @Nullable String longName, @Nullable Address locationAddress, @Nullable Set<Region> regions) {
        this.id = id;
        this.name = name;
        this.longName = longName;
        this.locationAddress = locationAddress;
        this.regions = regions == null ? ImmutableSet.of() : ImmutableSet.copyOf(regions);
    }

    public int getId() {
        return this.id;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getLongName() {
        return this.longName;
    }

    @Nullable
    public Address getLocationAddress() {
        return this.locationAddress;
    }

    public Set<Region> getRegions() {
        return this.regions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Datacenter that = (Datacenter)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.longName, (Object)that.longName) && Objects.equal((Object)this.locationAddress, (Object)that.locationAddress) && Objects.equal(this.regions, that.regions);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.name, this.longName, this.locationAddress, this.regions});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("name", (Object)this.name).add("longName", (Object)this.longName).add("locationAddress", (Object)this.locationAddress).add("regions", this.regions).toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected int id;
        protected String name;
        protected String longName;
        protected Address locationAddress;
        protected Set<Region> regions = ImmutableSet.of();

        protected abstract T self();

        public T id(int id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T longName(String longName) {
            this.longName = longName;
            return this.self();
        }

        public T locationAddress(Address locationAddress) {
            this.locationAddress = locationAddress;
            return this.self();
        }

        public T regions(Set<Region> regions) {
            this.regions = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(regions, (Object)"regions")));
            return this.self();
        }

        public T regions(Region ... in) {
            return this.regions((Set<Region>)ImmutableSet.copyOf((Object[])in));
        }

        public Datacenter build() {
            return new Datacenter(this.id, this.name, this.longName, this.locationAddress, this.regions);
        }

        public T fromDatacenter(Datacenter in) {
            return ((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).name(in.getName())).longName(in.getLongName())).locationAddress(in.getLocationAddress())).regions(in.getRegions());
        }
    }
}

