/*
 * Decompiled with CFR 0.152.
 */
package lizard.tiff;

import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import lizard.tiff.Header;
import lizard.tiff.IFD;
import lizard.util.MemoryFileInputFilter;
import lizard.util.MotorolaIntelInputFilter;

public class Tiff {
    Header header = new Header();
    IFD[] pages = null;
    int pageCount = 0;

    public int getPageCount() {
        return this.pageCount;
    }

    public Image getImage(int page) {
        if (this.pageCount == 0 || page > this.pageCount) {
            return null;
        }
        return this.pages[page].getImage();
    }

    public Object getImageProducer(int page) {
        if (this.pageCount == 0 || page > this.pageCount) {
            return null;
        }
        return this.pages[page].getImageProducer();
    }

    public void write(RandomAccessFile raf) throws IOException {
        long offset = this.header.offset;
        MotorolaIntelInputFilter out = new MotorolaIntelInputFilter(raf, this.header.byteOrder == 18761);
        if (this.pageCount == 0) {
            return;
        }
        this.header.write(out);
        offset = this.header.offset;
        int i = 0;
        while (i < this.pageCount) {
            out.seek(offset);
            this.pages[i].write(out);
            offset = this.pages[i].offset;
            ++i;
        }
    }

    public void readInputStream(InputStream input) throws IOException {
        int CHUNK = 10240;
        int max = 10 * CHUNK;
        byte[] tmp = new byte[CHUNK];
        byte[] bytesArray = new byte[max];
        int i = 0;
        int count = 0;
        while ((count = input.read(tmp)) != -1) {
            if (i + count > max) {
                byte[] ba = new byte[i + count + CHUNK];
                System.arraycopy(bytesArray, 0, ba, 0, i);
                max = i + count + CHUNK;
                bytesArray = ba;
            }
            System.arraycopy(tmp, 0, bytesArray, i, count);
            i += count;
        }
        tmp = null;
        tmp = new byte[i];
        System.arraycopy(bytesArray, 0, tmp, 0, i);
        bytesArray = tmp;
        this.read(bytesArray);
    }

    public void read(byte[] bytesArray) throws IOException {
        MemoryFileInputFilter in = new MemoryFileInputFilter(bytesArray);
        this.pageCount = 0;
        this.pages = new IFD[10];
        this.header.read(in);
        long offset = this.header.offset;
        while (offset != 0L) {
            in.seek(offset);
            this.pages[this.pageCount] = new IFD();
            this.pages[this.pageCount].read(in);
            offset = this.pages[this.pageCount].offset;
            ++this.pageCount;
            if (this.pageCount < 10 || offset == 0L) continue;
            System.out.println("Oop, I was cheating and only allowed for 10 pages in a tif file");
            break;
        }
        in.close();
    }

    public String toString() {
        String s = "Tiff has " + this.pageCount + " pages\n\n";
        s = String.valueOf(s) + this.header.toString() + "\n";
        int i = 0;
        while (i < this.pageCount) {
            s = String.valueOf(s) + "Page #" + i + "\n" + this.pages[i].toString();
            ++i;
        }
        return s;
    }
}

