/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import java.io.IOException;
import java.nio.channels.FileChannel;
import org.iq80.leveldb.impl.LogChunkType;
import org.iq80.leveldb.impl.LogMonitor;
import org.iq80.leveldb.impl.Logs;
import org.iq80.leveldb.util.DynamicSliceOutput;
import org.iq80.leveldb.util.Slice;
import org.iq80.leveldb.util.SliceInput;
import org.iq80.leveldb.util.SliceOutput;
import org.iq80.leveldb.util.Slices;

public class LogReader {
    private final FileChannel fileChannel;
    private final LogMonitor monitor;
    private final boolean verifyChecksums;
    private final long initialOffset;
    private boolean eof;
    private long lastRecordOffset;
    private long endOfBufferOffset;
    private final DynamicSliceOutput recordScratch = new DynamicSliceOutput(32768);
    private final SliceOutput blockScratch = Slices.allocate(32768).output();
    private SliceInput currentBlock = Slices.EMPTY_SLICE.input();
    private Slice currentChunk = Slices.EMPTY_SLICE;

    public LogReader(FileChannel fileChannel, LogMonitor monitor, boolean verifyChecksums, long initialOffset) {
        this.fileChannel = fileChannel;
        this.monitor = monitor;
        this.verifyChecksums = verifyChecksums;
        this.initialOffset = initialOffset;
    }

    public long getLastRecordOffset() {
        return this.lastRecordOffset;
    }

    private boolean skipToInitialBlock() {
        int offsetInBlock = (int)(this.initialOffset % 32768L);
        long blockStartLocation = this.initialOffset - (long)offsetInBlock;
        if (offsetInBlock > 32762) {
            blockStartLocation += 32768L;
        }
        this.endOfBufferOffset = blockStartLocation;
        if (blockStartLocation > 0L) {
            try {
                this.fileChannel.position(blockStartLocation);
            }
            catch (IOException e) {
                this.reportDrop(blockStartLocation, e);
                return false;
            }
        }
        return true;
    }

    public Slice readRecord() {
        this.recordScratch.reset();
        if (this.lastRecordOffset < this.initialOffset && !this.skipToInitialBlock()) {
            return null;
        }
        long prospectiveRecordOffset = 0L;
        boolean inFragmentedRecord = false;
        block8: while (true) {
            long physicalRecordOffset = this.endOfBufferOffset - (long)this.currentChunk.length();
            LogChunkType chunkType = this.readNextChunk();
            switch (chunkType) {
                case FULL: {
                    if (inFragmentedRecord) {
                        this.reportCorruption(this.recordScratch.size(), "Partial record without end");
                    }
                    this.recordScratch.reset();
                    this.lastRecordOffset = prospectiveRecordOffset = physicalRecordOffset;
                    return this.currentChunk.copySlice();
                }
                case FIRST: {
                    if (inFragmentedRecord) {
                        this.reportCorruption(this.recordScratch.size(), "Partial record without end");
                        this.recordScratch.reset();
                    }
                    prospectiveRecordOffset = physicalRecordOffset;
                    this.recordScratch.writeBytes(this.currentChunk);
                    inFragmentedRecord = true;
                    continue block8;
                }
                case MIDDLE: {
                    if (!inFragmentedRecord) {
                        this.reportCorruption(this.recordScratch.size(), "Missing start of fragmented record");
                        this.recordScratch.reset();
                        continue block8;
                    }
                    this.recordScratch.writeBytes(this.currentChunk);
                    continue block8;
                }
                case LAST: {
                    if (!inFragmentedRecord) {
                        this.reportCorruption(this.recordScratch.size(), "Missing start of fragmented record");
                        this.recordScratch.reset();
                        continue block8;
                    }
                    this.recordScratch.writeBytes(this.currentChunk);
                    this.lastRecordOffset = prospectiveRecordOffset;
                    return this.recordScratch.slice().copySlice();
                }
                case EOF: {
                    if (inFragmentedRecord) {
                        this.reportCorruption(this.recordScratch.size(), "Partial record without end");
                        this.recordScratch.reset();
                    }
                    return null;
                }
                case BAD_CHUNK: {
                    if (!inFragmentedRecord) continue block8;
                    this.reportCorruption(this.recordScratch.size(), "Error in middle of record");
                    inFragmentedRecord = false;
                    this.recordScratch.reset();
                    continue block8;
                }
            }
            int dropSize = this.currentChunk.length();
            if (inFragmentedRecord) {
                dropSize += this.recordScratch.size();
            }
            this.reportCorruption(dropSize, String.format("Unexpected chunk type %s", new Object[]{chunkType}));
            inFragmentedRecord = false;
            this.recordScratch.reset();
        }
    }

    private LogChunkType readNextChunk() {
        int actualChecksum;
        this.currentChunk = Slices.EMPTY_SLICE;
        if (this.currentBlock.available() < 7 && !this.readNextBlock() && this.eof) {
            return LogChunkType.EOF;
        }
        int expectedChecksum = this.currentBlock.readInt();
        int length = this.currentBlock.readUnsignedByte();
        byte chunkTypeId = this.currentBlock.readByte();
        LogChunkType chunkType = LogChunkType.getLogChunkTypeByPersistentId(chunkTypeId);
        if ((length |= this.currentBlock.readUnsignedByte() << 8) > this.currentBlock.available()) {
            int dropSize = this.currentBlock.available() + 7;
            this.reportCorruption(dropSize, "Invalid chunk length");
            this.currentBlock = Slices.EMPTY_SLICE.input();
            return LogChunkType.BAD_CHUNK;
        }
        if (chunkType == LogChunkType.ZERO_TYPE && length == 0) {
            this.currentBlock = Slices.EMPTY_SLICE.input();
            return LogChunkType.BAD_CHUNK;
        }
        if (this.endOfBufferOffset - 7L - (long)length < this.initialOffset) {
            this.currentBlock.skipBytes(length);
            return LogChunkType.BAD_CHUNK;
        }
        this.currentChunk = this.currentBlock.readBytes(length);
        if (this.verifyChecksums && (actualChecksum = Logs.getChunkChecksum(chunkTypeId, this.currentChunk)) != expectedChecksum) {
            int dropSize = this.currentBlock.available() + 7;
            this.currentBlock = Slices.EMPTY_SLICE.input();
            this.reportCorruption(dropSize, "Invalid chunk checksum");
            return LogChunkType.BAD_CHUNK;
        }
        if (chunkType == LogChunkType.UNKNOWN) {
            this.reportCorruption(length, String.format("Unknown chunk type %d", chunkType.getPersistentId()));
            return LogChunkType.BAD_CHUNK;
        }
        return chunkType;
    }

    public boolean readNextBlock() {
        if (this.eof) {
            return false;
        }
        this.blockScratch.reset();
        while (this.blockScratch.writableBytes() > 0) {
            try {
                int bytesRead = this.blockScratch.writeBytes(this.fileChannel, this.blockScratch.writableBytes());
                if (bytesRead < 0) {
                    this.eof = true;
                    break;
                }
                this.endOfBufferOffset += (long)bytesRead;
            }
            catch (IOException e) {
                this.currentBlock = Slices.EMPTY_SLICE.input();
                this.reportDrop(32768L, e);
                this.eof = true;
                return false;
            }
        }
        this.currentBlock = this.blockScratch.slice().input();
        return this.currentBlock.isReadable();
    }

    private void reportCorruption(long bytes, String reason) {
        if (this.monitor != null) {
            this.monitor.corruption(bytes, reason);
        }
    }

    private void reportDrop(long bytes, Throwable reason) {
        if (this.monitor != null) {
            this.monitor.corruption(bytes, reason);
        }
    }
}

