/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.util.KeyValueHolder;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public final class OgnlHelper {
    private static final Pattern INDEX_PATTERN = Pattern.compile("^(.*)\\[(.*)\\]$");

    private OgnlHelper() {
    }

    public static boolean isValidOgnlExpression(String expression) {
        if (ObjectHelper.isEmpty(expression)) {
            return false;
        }
        int bracketBegin = StringHelper.countChar(expression, '[');
        int bracketEnd = StringHelper.countChar(expression, ']');
        if (bracketBegin > 0 && bracketEnd > 0) {
            return bracketBegin == bracketEnd;
        }
        return expression.contains(".");
    }

    public static boolean isInvalidValidOgnlExpression(String expression) {
        if (ObjectHelper.isEmpty(expression)) {
            return false;
        }
        if (!(expression.contains(".") || expression.contains("[") || expression.contains("]"))) {
            return false;
        }
        int bracketBegin = StringHelper.countChar(expression, '[');
        int bracketEnd = StringHelper.countChar(expression, ']');
        if (bracketBegin > 0 || bracketEnd > 0) {
            return bracketBegin != bracketEnd;
        }
        return expression.contains("..");
    }

    public static void validateMethodName(String method) {
        if (ObjectHelper.isEmpty(method)) {
            return;
        }
        for (int i = 0; i < method.length(); ++i) {
            char ch = method.charAt(i);
            if (i == 0 && '.' == ch) continue;
            if (ch == '(' || ch == '[' || ch == '.' || ch == '?') break;
            if (i == 0 && !Character.isJavaIdentifierStart(ch)) {
                throw new IllegalArgumentException("Method name must start with a valid java identifier at position: 0 in method: " + method);
            }
            if (Character.isJavaIdentifierPart(ch)) continue;
            throw new IllegalArgumentException("Method name must be valid java identifier at position: " + i + " in method: " + method);
        }
    }

    public static boolean isNullSafeOperator(String ognlExpression) {
        if (ObjectHelper.isEmpty(ognlExpression)) {
            return false;
        }
        return ognlExpression.startsWith("?");
    }

    public static String removeLeadingOperators(String ognlExpression) {
        if (ObjectHelper.isEmpty(ognlExpression)) {
            return ognlExpression;
        }
        if (ognlExpression.startsWith("?")) {
            ognlExpression = ognlExpression.substring(1);
        }
        if (ognlExpression.startsWith(".")) {
            ognlExpression = ognlExpression.substring(1);
        }
        return ognlExpression;
    }

    public static String removeTrailingOperators(String ognlExpression) {
        if (ObjectHelper.isEmpty(ognlExpression)) {
            return ognlExpression;
        }
        if (ognlExpression.contains("[")) {
            return StringHelper.before(ognlExpression, "[");
        }
        return ognlExpression;
    }

    public static String removeOperators(String ognlExpression) {
        return OgnlHelper.removeLeadingOperators(OgnlHelper.removeTrailingOperators(ognlExpression));
    }

    public static KeyValueHolder<String, String> isOgnlIndex(String ognlExpression) {
        Matcher matcher = INDEX_PATTERN.matcher(ognlExpression);
        if (matcher.matches()) {
            String value;
            String key = matcher.group(1);
            if (ObjectHelper.isEmpty(key)) {
                key = null;
            }
            if (ObjectHelper.isEmpty(value = matcher.group(2))) {
                value = null;
            }
            return new KeyValueHolder<String, String>(key, value);
        }
        return null;
    }

    public static List<String> splitOgnl(String ognl) {
        String last;
        ArrayList<String> methods = new ArrayList<String>();
        if (ObjectHelper.isEmpty(ognl)) {
            return methods;
        }
        StringBuilder sb = new StringBuilder();
        int j = 0;
        boolean squareBracket = false;
        boolean parenthesisBracket = false;
        for (int i = 0; i < ognl.length(); ++i) {
            String s;
            char ch = ognl.charAt(i);
            if (j == 0 || j == 1 && ognl.charAt(i - 1) == '?' || ch != '.' && ch != '?' && ch != ']') {
                sb.append(ch);
                if (ch == '[' && !parenthesisBracket) {
                    squareBracket = true;
                } else if (ch == '(') {
                    parenthesisBracket = true;
                } else if (ch == ')') {
                    parenthesisBracket = false;
                }
                ++j;
                continue;
            }
            if (ch == '.' && !squareBracket && !parenthesisBracket) {
                s = sb.toString();
                sb.setLength(0);
                if (s.endsWith("?")) {
                    sb.append("?");
                    s = s.substring(0, s.length() - 1);
                }
                methods.add(s);
                j = 0;
            } else if (ch == ']' && !parenthesisBracket) {
                sb.append(ch);
                s = sb.toString();
                sb.setLength(0);
                methods.add(s);
                j = 0;
                squareBracket = false;
            }
            if (ch != ']' || parenthesisBracket) {
                sb.append(ch);
            }
            if (j <= 0) continue;
            ++j;
        }
        if (sb.length() > 0) {
            methods.add(sb.toString());
        }
        String string = last = methods.isEmpty() ? null : (String)methods.get(methods.size() - 1);
        if (parenthesisBracket && last != null && last.contains("(") && !last.endsWith(")")) {
            throw new IllegalArgumentException("Method should end with parenthesis, was " + last);
        }
        return methods;
    }
}

