/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.wro4j;

import com.google.common.base.Joiner;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.cache.CacheKey;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.cache.CacheValue;
import ro.isdc.wro.cache.impl.LruMemoryCacheStrategy;

public class DiskbackedCache
implements CacheStrategy<CacheKey, CacheValue>,
Closeable {
    public static final String NAME = "disk-memory";
    public static final String DB_PROP_KEY = "cacheDB";
    private static final String TABLE = "cache";
    private static final String SQL_CLEAR = "DELETE FROM cache";
    private static final String SQL_SHUTDOWN = "SHUTDOWN";
    private static final String GROUPNAME = "groupname";
    private static final String TYPE = "type";
    private static final String HASH = "hash";
    private static final String RAW_DATA = "rawdata";
    public static final String SQL_PUT_CACHE_VALUE = "MERGE INTO cache (groupname, type, hash, rawdata) VALUES (?,?,?,?)";
    public static final String SQL_GET_QUERY = "SELECT hash,rawdata FROM cache WHERE groupname=? and type = ?";
    private final String dbPathString;
    private CacheStrategy<CacheKey, CacheValue> defaultCache;
    private Connection dbConnection;
    private boolean destroyed = false;

    public DiskbackedCache(int lruSize, String dbPathString) {
        this.defaultCache = new LruMemoryCacheStrategy(lruSize);
        this.dbPathString = dbPathString;
    }

    DiskbackedCache(int lruSize) {
        this(lruSize, "mem:" + UUID.randomUUID());
    }

    private synchronized void init() {
        if (this.destroyed) {
            throw new WroRuntimeException("DiskbackedCache has already been destroyed/closed");
        }
        if (this.dbConnection != null) {
            return;
        }
        String path = this.dbPathString;
        if (path == null && ApplicationContextHolder.get() != null) {
            GeonetworkDataDirectory geonetworkDataDirectory = (GeonetworkDataDirectory)ApplicationContextHolder.get().getBean(GeonetworkDataDirectory.class);
            path = geonetworkDataDirectory.getSystemDataDir().resolve("wro4j-cache").toString();
        }
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
        Object[] initSql = new String[]{"CREATE TABLE IF NOT EXISTS cache(groupname  VARCHAR(128) NOT NULL, type VARCHAR(3) NOT NULL, hash VARCHAR(256) NOT NULL, rawdata CLOB NOT NULL, PRIMARY KEY (groupname, type))"};
        String init = ";INIT=" + Joiner.on((String)"\\;").join(initSql) + ";DB_CLOSE_ON_EXIT=FALSE;";
        try {
            this.dbConnection = DriverManager.getConnection("jdbc:h2:" + path + init, "wro4jcache", "");
        }
        catch (SQLException e) {
            throw new WroRuntimeException("Error creating the wro4j disk-cache", (Throwable)e);
        }
    }

    public void put(CacheKey key, CacheValue value) {
        this.init();
        this.defaultCache.put((Object)key, (Object)value);
        try (PreparedStatement statement = this.dbConnection.prepareStatement(SQL_PUT_CACHE_VALUE);){
            statement.setString(1, key.getGroupName());
            statement.setString(2, key.getType().toString());
            statement.setString(3, value.getHash());
            statement.setString(4, value.getRawContent());
            statement.execute();
        }
        catch (SQLException e) {
            throw new WroRuntimeException("Error putting a value into the cache", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CacheValue get(CacheKey key) {
        this.init();
        CacheValue cacheValue = (CacheValue)this.defaultCache.get((Object)key);
        if (cacheValue != null) {
            return cacheValue;
        }
        try (PreparedStatement statement = this.dbConnection.prepareStatement(SQL_GET_QUERY);){
            statement.setString(1, key.getGroupName());
            statement.setString(2, key.getType().toString());
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return null;
                String hash = resultSet.getString(HASH);
                String rawData = resultSet.getString(RAW_DATA);
                CacheValue value = CacheValue.valueOf((String)rawData, (String)hash);
                this.defaultCache.put((Object)key, (Object)value);
                CacheValue cacheValue2 = value;
                return cacheValue2;
            }
        }
        catch (SQLException e) {
            throw new WroRuntimeException("Error removing a value from the cache", (Throwable)e);
        }
    }

    public void clear() {
        this.init();
        try (Statement statement = this.dbConnection.createStatement();){
            statement.execute(SQL_CLEAR);
        }
        catch (SQLException e) {
            throw new WroRuntimeException("Error clearing the cache", (Throwable)e);
        }
        this.defaultCache.clear();
    }

    public void destroy() {
        try {
            if (this.dbConnection != null) {
                this.dbConnection.createStatement().execute(SQL_SHUTDOWN);
                this.dbConnection.close();
            }
        }
        catch (SQLException e) {
            throw new WroRuntimeException("Database is already closed", (Throwable)e);
        }
        finally {
            this.defaultCache.destroy();
            this.destroyed = true;
        }
    }

    @Override
    public void close() throws IOException {
        this.destroy();
    }
}

