/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.brewer.styling.builder;

import org.geotools.brewer.styling.builder.AbstractStyleBuilder;
import org.geotools.brewer.styling.builder.StyleBuilder;
import org.geotools.styling.ShadedRelief;
import org.opengis.filter.expression.Expression;

public class ShadedReliefBuilder
extends AbstractStyleBuilder<ShadedRelief> {
    private Expression factor;
    private boolean brightnessOnly;

    public ShadedReliefBuilder() {
        this((AbstractStyleBuilder<?>)null);
    }

    public ShadedReliefBuilder(AbstractStyleBuilder<?> parent) {
        super(parent);
        this.reset();
    }

    public ShadedReliefBuilder factor(Expression factor) {
        this.factor = factor;
        this.unset = false;
        return this;
    }

    public ShadedReliefBuilder factor(double factor) {
        return this.factor(this.literal(factor));
    }

    public ShadedReliefBuilder factor(String cqlExpression) {
        return this.factor(this.cqlExpression(cqlExpression));
    }

    public ShadedReliefBuilder brightnessOnly(boolean brightnessOnly) {
        this.brightnessOnly = brightnessOnly;
        this.unset = false;
        return this;
    }

    @Override
    public ShadedRelief build() {
        if (this.unset) {
            return null;
        }
        ShadedRelief relief = this.sf.shadedRelief(this.factor, this.brightnessOnly);
        return relief;
    }

    public ShadedReliefBuilder reset() {
        this.factor = this.literal(0);
        this.brightnessOnly = false;
        this.unset = false;
        return this;
    }

    public ShadedReliefBuilder reset(ShadedRelief relief) {
        if (relief == null) {
            return this.reset();
        }
        this.brightnessOnly = relief.isBrightnessOnly();
        this.factor = relief.getReliefFactor();
        this.unset = false;
        return this;
    }

    @Override
    public ShadedReliefBuilder unset() {
        return (ShadedReliefBuilder)super.unset();
    }

    @Override
    protected void buildStyleInternal(StyleBuilder sb) {
        sb.featureTypeStyle().rule().raster().shadedRelief().init(this);
    }
}

