/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.ShortCollection;
import bak.pcj.adapter.CollectionToShortCollectionAdapter;
import bak.pcj.map.AbstractObjectKeyShortMap;
import bak.pcj.map.MapDefaults;
import bak.pcj.map.ObjectKeyShortMap;
import bak.pcj.map.ObjectKeyShortMapIterator;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MapToObjectKeyShortMapAdapter
extends AbstractObjectKeyShortMap
implements ObjectKeyShortMap {
    protected Map map;
    protected Short lastValue;

    public MapToObjectKeyShortMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToObjectKeyShortMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(Object key) {
        this.lastValue = (Short)this.map.get(key);
        return this.lastValue != null;
    }

    public boolean containsValue(short value) {
        return this.map.containsValue(new Short(value));
    }

    public ObjectKeyShortMapIterator entries() {
        return new ObjectKeyShortMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToObjectKeyShortMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public Object getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return this.lastEntry.getKey();
            }

            public short getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Short)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public short get(Object key) {
        Short value = (Short)this.map.get(key);
        return value == null ? MapDefaults.defaultShort() : value;
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public short lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public short put(Object key, short value) {
        Short oldValue = this.map.put(key, new Short(value));
        return oldValue == null ? MapDefaults.defaultShort() : oldValue;
    }

    public short remove(Object key) {
        Short value = (Short)this.map.remove(key);
        return value == null ? MapDefaults.defaultShort() : value;
    }

    public int size() {
        return this.map.size();
    }

    public ShortCollection values() {
        return new CollectionToShortCollectionAdapter(this.map.values());
    }

    public short tget(Object key) {
        Short value = (Short)this.map.get(key);
        if (value == null) {
            Exceptions.noSuchMapping(key);
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isObjectKeyShortAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

