/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.LongCollection;
import bak.pcj.adapter.CollectionToLongCollectionAdapter;
import bak.pcj.map.AbstractObjectKeyLongMap;
import bak.pcj.map.MapDefaults;
import bak.pcj.map.ObjectKeyLongMap;
import bak.pcj.map.ObjectKeyLongMapIterator;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MapToObjectKeyLongMapAdapter
extends AbstractObjectKeyLongMap
implements ObjectKeyLongMap {
    protected Map map;
    protected Long lastValue;

    public MapToObjectKeyLongMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToObjectKeyLongMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(Object key) {
        this.lastValue = (Long)this.map.get(key);
        return this.lastValue != null;
    }

    public boolean containsValue(long value) {
        return this.map.containsValue(new Long(value));
    }

    public ObjectKeyLongMapIterator entries() {
        return new ObjectKeyLongMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToObjectKeyLongMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public Object getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return this.lastEntry.getKey();
            }

            public long getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Long)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public long get(Object key) {
        Long value = (Long)this.map.get(key);
        return value == null ? MapDefaults.defaultLong() : value;
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public long lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public long put(Object key, long value) {
        Long oldValue = this.map.put(key, new Long(value));
        return oldValue == null ? MapDefaults.defaultLong() : oldValue;
    }

    public long remove(Object key) {
        Long value = (Long)this.map.remove(key);
        return value == null ? MapDefaults.defaultLong() : value;
    }

    public int size() {
        return this.map.size();
    }

    public LongCollection values() {
        return new CollectionToLongCollectionAdapter(this.map.values());
    }

    public long tget(Object key) {
        Long value = (Long)this.map.get(key);
        if (value == null) {
            Exceptions.noSuchMapping(key);
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isObjectKeyLongAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

