/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.DoubleCollection;
import bak.pcj.adapter.CollectionToDoubleCollectionAdapter;
import bak.pcj.adapter.SetToDoubleSetAdapter;
import bak.pcj.map.AbstractDoubleKeyDoubleMap;
import bak.pcj.map.DoubleKeyDoubleMap;
import bak.pcj.map.DoubleKeyDoubleMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.DoubleSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToDoubleKeyDoubleMapAdapter
extends AbstractDoubleKeyDoubleMap
implements DoubleKeyDoubleMap {
    protected Map map;
    protected Double lastValue;

    public MapToDoubleKeyDoubleMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToDoubleKeyDoubleMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(double key) {
        this.lastValue = (Double)this.map.get(new Double(key));
        return this.lastValue != null;
    }

    public boolean containsValue(double value) {
        return this.map.containsValue(new Double(value));
    }

    public DoubleKeyDoubleMapIterator entries() {
        return new DoubleKeyDoubleMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToDoubleKeyDoubleMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public double getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Double)this.lastEntry.getKey();
            }

            public double getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Double)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public double get(double key) {
        Double value = (Double)this.map.get(new Double(key));
        return value == null ? MapDefaults.defaultDouble() : value;
    }

    public DoubleSet keySet() {
        return new SetToDoubleSetAdapter(this.map.keySet());
    }

    public double lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public double put(double key, double value) {
        Double oldValue = this.map.put(new Double(key), new Double(value));
        return oldValue == null ? MapDefaults.defaultDouble() : oldValue;
    }

    public double remove(double key) {
        Double value = (Double)this.map.remove(new Double(key));
        return value == null ? MapDefaults.defaultDouble() : value;
    }

    public int size() {
        return this.map.size();
    }

    public DoubleCollection values() {
        return new CollectionToDoubleCollectionAdapter(this.map.values());
    }

    public double tget(double key) {
        Double value = (Double)this.map.get(new Double(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isDoubleKeyDoubleAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

