/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj;

import bak.pcj.BooleanCollection;
import bak.pcj.BooleanIterator;
import bak.pcj.util.Display;
import bak.pcj.util.Exceptions;

public abstract class AbstractBooleanCollection
implements BooleanCollection {
    protected AbstractBooleanCollection() {
    }

    public boolean add(boolean v) {
        Exceptions.unsupported("add");
        return false;
    }

    public boolean addAll(BooleanCollection c) {
        BooleanIterator i = c.iterator();
        boolean result = false;
        while (i.hasNext()) {
            result |= this.add(i.next());
        }
        return result;
    }

    public void clear() {
        BooleanIterator i = this.iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public boolean contains(boolean v) {
        BooleanIterator i = this.iterator();
        while (i.hasNext()) {
            if (i.next() != v) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(BooleanCollection c) {
        BooleanIterator i = c.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean remove(boolean v) {
        BooleanIterator i = this.iterator();
        boolean result = false;
        while (i.hasNext()) {
            if (i.next() != v) continue;
            i.remove();
            result = true;
            break;
        }
        return result;
    }

    public boolean removeAll(BooleanCollection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        BooleanIterator i = this.iterator();
        boolean result = false;
        while (i.hasNext()) {
            if (!c.contains(i.next())) continue;
            i.remove();
            result = true;
        }
        return result;
    }

    public boolean retainAll(BooleanCollection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        BooleanIterator i = this.iterator();
        boolean result = false;
        while (i.hasNext()) {
            if (c.contains(i.next())) continue;
            i.remove();
            result = true;
        }
        return result;
    }

    public int size() {
        BooleanIterator i = this.iterator();
        int size = 0;
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public boolean[] toArray() {
        return this.toArray(null);
    }

    public boolean[] toArray(boolean[] a) {
        int size = this.size();
        if (a == null || a.length < size) {
            a = new boolean[size];
        }
        BooleanIterator i = this.iterator();
        int index = 0;
        while (i.hasNext()) {
            a[index] = i.next();
            ++index;
        }
        return a;
    }

    public void trimToSize() {
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        BooleanIterator i = this.iterator();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            s.append(Display.display(i.next()));
        }
        s.append(']');
        return s.toString();
    }

    public abstract BooleanIterator iterator();
}

