/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.functions;

import com.google.common.collect.ImmutableList;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.functions.NodeAndTemplateOptionsToStatement;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.scriptbuilder.InitScript;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.statements.ssh.InstallRSAPrivateKey;

@Singleton
public class NodeAndTemplateOptionsToStatementWithoutPublicKey
implements NodeAndTemplateOptionsToStatement {
    @Override
    public Statement apply(NodeMetadata node, TemplateOptions options) {
        ImmutableList bootstrap;
        ImmutableList.Builder builder = ImmutableList.builder();
        if (options.getRunScript() != null) {
            builder.add((Object)options.getRunScript());
        }
        if (options.getPrivateKey() != null) {
            builder.add((Object)new InstallRSAPrivateKey(options.getPrivateKey()));
        }
        if (!(bootstrap = builder.build()).isEmpty()) {
            if (options.getTaskName() == null && !(options.getRunScript() instanceof InitScript)) {
                options.nameTask("bootstrap");
            }
            return bootstrap.size() == 1 ? (Statement)bootstrap.get(0) : new StatementList((Iterable)bootstrap);
        }
        return null;
    }
}

