/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.domain.rdata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.util.Map;

public class SOAData
extends ForwardingMap<String, Object> {
    private final String mname;
    private final String rname;
    private final int serial;
    private final int refresh;
    private final int retry;
    private final int expire;
    private final int minimum;
    private final transient ImmutableMap<String, Object> delegate;

    @ConstructorProperties(value={"mname", "rname", "serial", "refresh", "retry", "expire", "minimum"})
    private SOAData(String mname, String rname, int serial, int refresh, int retry, int expire, int minimum) {
        this.mname = (String)Preconditions.checkNotNull((Object)mname, (Object)"mname");
        this.rname = (String)Preconditions.checkNotNull((Object)rname, (String)"rname of %s", (Object[])new Object[]{mname});
        Preconditions.checkArgument((serial >= 0 ? 1 : 0) != 0, (String)"serial of %s must be unsigned", (Object[])new Object[]{mname});
        this.serial = serial;
        Preconditions.checkArgument((refresh >= 0 ? 1 : 0) != 0, (String)"refresh of %s must be unsigned", (Object[])new Object[]{mname});
        this.refresh = refresh;
        Preconditions.checkArgument((retry >= 0 ? 1 : 0) != 0, (String)"retry of %s must be unsigned", (Object[])new Object[]{mname});
        this.retry = retry;
        Preconditions.checkArgument((expire >= 0 ? 1 : 0) != 0, (String)"expire of %s must be unsigned", (Object[])new Object[]{mname});
        this.expire = expire;
        Preconditions.checkArgument((minimum >= 0 ? 1 : 0) != 0, (String)"minimum of %s must be unsigned", (Object[])new Object[]{mname});
        this.minimum = minimum;
        this.delegate = ImmutableMap.builder().put((Object)"mname", Preconditions.checkNotNull((Object)mname, (Object)"mname")).put((Object)"rname", Preconditions.checkNotNull((Object)rname, (String)"rname of %s", (Object[])new Object[]{mname})).put((Object)"serial", (Object)serial).put((Object)"refresh", (Object)refresh).put((Object)"retry", (Object)retry).put((Object)"expire", (Object)expire).put((Object)"minimum", (Object)minimum).build();
    }

    public String getMname() {
        return this.mname;
    }

    public String getRname() {
        return this.rname;
    }

    public int getSerial() {
        return this.serial;
    }

    public int getRefresh() {
        return this.refresh;
    }

    public int getRetry() {
        return this.retry;
    }

    public int getExpire() {
        return this.expire;
    }

    public int getMinimum() {
        return this.minimum;
    }

    protected Map<String, Object> delegate() {
        return this.delegate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return SOAData.builder().from(this);
    }

    public static final class Builder {
        private String mname;
        private String rname;
        private int serial = -1;
        private int refresh = -1;
        private int retry = -1;
        private int expire = -1;
        private int minimum = -1;

        public Builder mname(String mname) {
            this.mname = mname;
            return this;
        }

        public Builder rname(String rname) {
            this.rname = rname;
            return this;
        }

        public Builder serial(int serial) {
            this.serial = serial;
            return this;
        }

        public Builder refresh(int refresh) {
            this.refresh = refresh;
            return this;
        }

        public Builder retry(int retry) {
            this.retry = retry;
            return this;
        }

        public Builder expire(int expire) {
            this.expire = expire;
            return this;
        }

        public Builder minimum(int minimum) {
            this.minimum = minimum;
            return this;
        }

        public SOAData build() {
            return new SOAData(this.mname, this.rname, this.serial, this.refresh, this.retry, this.expire, this.minimum);
        }

        public Builder from(SOAData in) {
            return this.mname(in.getMname()).rname(in.getRname()).serial(in.getSerial()).refresh(in.getRefresh()).expire(in.getExpire()).minimum(in.getMinimum());
        }
    }
}

