/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.CharCollection;
import bak.pcj.adapter.CollectionToCharCollectionAdapter;
import bak.pcj.adapter.SetToShortSetAdapter;
import bak.pcj.map.AbstractShortKeyCharMap;
import bak.pcj.map.MapDefaults;
import bak.pcj.map.ShortKeyCharMap;
import bak.pcj.map.ShortKeyCharMapIterator;
import bak.pcj.set.ShortSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToShortKeyCharMapAdapter
extends AbstractShortKeyCharMap
implements ShortKeyCharMap {
    protected Map map;
    protected Character lastValue;

    public MapToShortKeyCharMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToShortKeyCharMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(short key) {
        this.lastValue = (Character)this.map.get(new Short(key));
        return this.lastValue != null;
    }

    public boolean containsValue(char value) {
        return this.map.containsValue(new Character(value));
    }

    public ShortKeyCharMapIterator entries() {
        return new ShortKeyCharMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToShortKeyCharMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public short getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Short)this.lastEntry.getKey();
            }

            public char getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return ((Character)this.lastEntry.getValue()).charValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public char get(short key) {
        Character value = (Character)this.map.get(new Short(key));
        return value == null ? MapDefaults.defaultChar() : value.charValue();
    }

    public ShortSet keySet() {
        return new SetToShortSetAdapter(this.map.keySet());
    }

    public char lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue.charValue();
    }

    public char put(short key, char value) {
        Character oldValue = this.map.put(new Short(key), new Character(value));
        return oldValue == null ? MapDefaults.defaultChar() : oldValue.charValue();
    }

    public char remove(short key) {
        Character value = (Character)this.map.remove(new Short(key));
        return value == null ? MapDefaults.defaultChar() : value.charValue();
    }

    public int size() {
        return this.map.size();
    }

    public CharCollection values() {
        return new CollectionToCharCollectionAdapter(this.map.values());
    }

    public char tget(short key) {
        Character value = (Character)this.map.get(new Short(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value.charValue();
    }

    public boolean validate() {
        return Adapter.isShortKeyCharAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

