/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.CharCollection;
import bak.pcj.adapter.CollectionToCharCollectionAdapter;
import bak.pcj.adapter.SetToByteSetAdapter;
import bak.pcj.map.AbstractByteKeyCharMap;
import bak.pcj.map.ByteKeyCharMap;
import bak.pcj.map.ByteKeyCharMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.ByteSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToByteKeyCharMapAdapter
extends AbstractByteKeyCharMap
implements ByteKeyCharMap {
    protected Map map;
    protected Character lastValue;

    public MapToByteKeyCharMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToByteKeyCharMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(byte key) {
        this.lastValue = (Character)this.map.get(new Byte(key));
        return this.lastValue != null;
    }

    public boolean containsValue(char value) {
        return this.map.containsValue(new Character(value));
    }

    public ByteKeyCharMapIterator entries() {
        return new ByteKeyCharMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToByteKeyCharMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public byte getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Byte)this.lastEntry.getKey();
            }

            public char getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return ((Character)this.lastEntry.getValue()).charValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public char get(byte key) {
        Character value = (Character)this.map.get(new Byte(key));
        return value == null ? MapDefaults.defaultChar() : value.charValue();
    }

    public ByteSet keySet() {
        return new SetToByteSetAdapter(this.map.keySet());
    }

    public char lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue.charValue();
    }

    public char put(byte key, char value) {
        Character oldValue = this.map.put(new Byte(key), new Character(value));
        return oldValue == null ? MapDefaults.defaultChar() : oldValue.charValue();
    }

    public char remove(byte key) {
        Character value = (Character)this.map.remove(new Byte(key));
        return value == null ? MapDefaults.defaultChar() : value.charValue();
    }

    public int size() {
        return this.map.size();
    }

    public CharCollection values() {
        return new CollectionToCharCollectionAdapter(this.map.values());
    }

    public char tget(byte key) {
        Character value = (Character)this.map.get(new Byte(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value.charValue();
    }

    public boolean validate() {
        return Adapter.isByteKeyCharAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

