/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.adapter.ListIteratorToFloatListIteratorAdapter;
import bak.pcj.list.AbstractFloatList;
import bak.pcj.list.FloatListIterator;
import bak.pcj.util.Exceptions;
import java.util.List;

public class ListToFloatListAdapter
extends AbstractFloatList {
    protected List list;

    public ListToFloatListAdapter(List list) {
        this(list, false);
    }

    public ListToFloatListAdapter(List list, boolean validate) {
        if (list == null) {
            Exceptions.nullArgument("list");
        }
        this.list = list;
        if (validate) {
            this.evalidate();
        }
    }

    public void add(int index, float v) {
        this.list.add(index, new Float(v));
    }

    public float get(int index) {
        return ((Float)this.list.get(index)).floatValue();
    }

    public FloatListIterator listIterator(int index) {
        return new ListIteratorToFloatListIteratorAdapter(this.list.listIterator(index));
    }

    public float removeElementAt(int index) {
        return ((Float)this.list.remove(index)).floatValue();
    }

    public float set(int index, float v) {
        return this.list.set(index, new Float(v)).floatValue();
    }

    public int size() {
        return this.list.size();
    }

    public boolean validate() {
        return Adapter.isFloatAdaptable(this.list);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("list");
        }
    }
}

