/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj;

import bak.pcj.LongCollection;
import bak.pcj.LongIterator;
import bak.pcj.util.Display;
import bak.pcj.util.Exceptions;

public abstract class AbstractLongCollection
implements LongCollection {
    protected AbstractLongCollection() {
    }

    public boolean add(long v) {
        Exceptions.unsupported("add");
        return false;
    }

    public boolean addAll(LongCollection c) {
        LongIterator i = c.iterator();
        boolean result = false;
        while (i.hasNext()) {
            result |= this.add(i.next());
        }
        return result;
    }

    public void clear() {
        LongIterator i = this.iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public boolean contains(long v) {
        LongIterator i = this.iterator();
        while (i.hasNext()) {
            if (i.next() != v) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(LongCollection c) {
        LongIterator i = c.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean remove(long v) {
        LongIterator i = this.iterator();
        boolean result = false;
        while (i.hasNext()) {
            if (i.next() != v) continue;
            i.remove();
            result = true;
            break;
        }
        return result;
    }

    public boolean removeAll(LongCollection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        LongIterator i = this.iterator();
        boolean result = false;
        while (i.hasNext()) {
            if (!c.contains(i.next())) continue;
            i.remove();
            result = true;
        }
        return result;
    }

    public boolean retainAll(LongCollection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        LongIterator i = this.iterator();
        boolean result = false;
        while (i.hasNext()) {
            if (c.contains(i.next())) continue;
            i.remove();
            result = true;
        }
        return result;
    }

    public int size() {
        LongIterator i = this.iterator();
        int size = 0;
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public long[] toArray() {
        return this.toArray(null);
    }

    public long[] toArray(long[] a) {
        int size = this.size();
        if (a == null || a.length < size) {
            a = new long[size];
        }
        LongIterator i = this.iterator();
        int index = 0;
        while (i.hasNext()) {
            a[index] = i.next();
            ++index;
        }
        return a;
    }

    public void trimToSize() {
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        LongIterator i = this.iterator();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            s.append(Display.display(i.next()));
        }
        s.append(']');
        return s.toString();
    }

    public abstract LongIterator iterator();
}

