/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.csw.services.getrecords;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.fao.geonet.csw.common.Csw;
import org.fao.geonet.kernel.csw.services.getrecords.IFieldMapper;
import org.jdom.Element;
import org.springframework.beans.factory.annotation.Autowired;

public class SortByParser {
    @Autowired
    IFieldMapper fieldMapper;

    public List<SortBuilder<FieldSortBuilder>> parseSortBy(Element request) {
        Element query = request.getChild("Query", Csw.NAMESPACE_CSW);
        if (query == null) {
            return Collections.emptyList();
        }
        Element sortBy = query.getChild("SortBy", Csw.NAMESPACE_OGC);
        if (sortBy == null) {
            return Collections.emptyList();
        }
        ArrayList<SortBuilder<FieldSortBuilder>> sortFields = new ArrayList<SortBuilder<FieldSortBuilder>>();
        List list = sortBy.getChildren();
        for (Element el : list) {
            String esSortFieldName = this.getEsSortFieldName(el);
            if (StringUtils.isEmpty((String)esSortFieldName)) continue;
            SortOrder esSortOrder = this.getEsSortOrder(el);
            sortFields.add((SortBuilder<FieldSortBuilder>)new FieldSortBuilder(esSortFieldName).order(esSortOrder));
        }
        return sortFields;
    }

    private String getEsSortFieldName(Element el) {
        String cswField = el.getChildText("PropertyName", Csw.NAMESPACE_OGC);
        if (cswField == null) {
            return null;
        }
        String matchingEsFieldOrEmpty = this.fieldMapper.mapSort(cswField);
        if (StringUtils.isEmpty((String)matchingEsFieldOrEmpty) && cswField.toLowerCase().equals("relevance")) {
            return "_score";
        }
        return matchingEsFieldOrEmpty;
    }

    private SortOrder getEsSortOrder(Element el) {
        String order = el.getChildText("SortOrder", Csw.NAMESPACE_OGC);
        boolean isDescOrder = "DESC".equals(order);
        return isDescOrder ? SortOrder.DESC : SortOrder.ASC;
    }
}

