/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.geotools.data.util.NullProgressListener;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.Aggregate;
import org.geotools.feature.visitor.GroupByVisitor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.util.ProgressListener;

public final class GroupByVisitorBuilder {
    private Expression aggregateAttribute;
    private Aggregate aggregateVisitor;
    private List<Expression> groupByAttributes = new ArrayList<Expression>();
    private ProgressListener progressListener;

    public GroupByVisitorBuilder withAggregateAttribute(int attributeTypeIndex, SimpleFeatureType type) {
        this.aggregateAttribute = this.toExpression(attributeTypeIndex, type);
        return this;
    }

    public GroupByVisitorBuilder withAggregateAttribute(String attributeName, SimpleFeatureType type) {
        this.aggregateAttribute = this.toExpression(attributeName, type);
        return this;
    }

    public GroupByVisitorBuilder withAggregateAttribute(Expression aggregateAttribute) {
        this.aggregateAttribute = aggregateAttribute;
        return this;
    }

    public GroupByVisitorBuilder withAggregateVisitor(Aggregate aggregateVisitor) {
        this.aggregateVisitor = aggregateVisitor;
        return this;
    }

    public GroupByVisitorBuilder withAggregateVisitor(String aggregateVisitorName) {
        this.aggregateVisitor = Aggregate.valueOfIgnoreCase(aggregateVisitorName);
        return this;
    }

    public GroupByVisitorBuilder withGroupByAttribute(int attributeTypeIndex, SimpleFeatureType type) {
        this.groupByAttributes.add(this.toExpression(attributeTypeIndex, type));
        return this;
    }

    public GroupByVisitorBuilder withGroupByAttribute(String attributeName, SimpleFeatureType type) {
        this.groupByAttributes.add(this.toExpression(attributeName, type));
        return this;
    }

    public GroupByVisitorBuilder withGroupByAttributes(Collection<String> attributesNames, SimpleFeatureType type) {
        for (String attributeName : attributesNames) {
            this.withGroupByAttribute(attributeName, type);
        }
        return this;
    }

    public GroupByVisitorBuilder withGroupByAttribute(Expression groupByAttribute) {
        this.groupByAttributes.add(groupByAttribute);
        return this;
    }

    public GroupByVisitorBuilder withProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
        return this;
    }

    private Expression toExpression(int attributeTypeIndex, SimpleFeatureType type) {
        FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
        AttributeDescriptor attribute = type.getDescriptor(attributeTypeIndex);
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute index '" + attributeTypeIndex + "' is not valid.");
        }
        return filterFactory.property(attribute.getLocalName());
    }

    private Expression toExpression(String attributeName, SimpleFeatureType type) {
        FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
        AttributeDescriptor attribute = type.getDescriptor(attributeName);
        if (attribute == null) {
            throw new IllegalArgumentException("Attribute '" + attributeName + "' is not valid.");
        }
        return filterFactory.property(attribute.getLocalName());
    }

    public GroupByVisitor build() {
        if (this.aggregateAttribute == null) {
            throw new IllegalArgumentException("An aggregate attribute is required.");
        }
        if (this.aggregateVisitor == null) {
            throw new IllegalArgumentException("An aggregate visitor is required.");
        }
        if (this.groupByAttributes == null || this.groupByAttributes.isEmpty()) {
            throw new IllegalArgumentException("At least one group by attribute is required.");
        }
        if (this.progressListener == null) {
            this.progressListener = new NullProgressListener();
        }
        return new GroupByVisitor(this.aggregateVisitor, this.aggregateAttribute, this.groupByAttributes, this.progressListener);
    }
}

