/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.ExecutionException;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.s3.Bucket;

@Singleton
public class GetRegionForBucket
implements Function<String, Optional<String>> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final LoadingCache<String, Optional<String>> bucketToRegion;

    @Inject
    public GetRegionForBucket(@Bucket LoadingCache<String, Optional<String>> bucketToRegion) {
        this.bucketToRegion = bucketToRegion;
    }

    public Optional<String> apply(String bucket) {
        try {
            return (Optional)this.bucketToRegion.get((Object)bucket);
        }
        catch (ExecutionException e) {
            this.logger.debug("error looking up region for bucket %s: %s", new Object[]{bucket, e});
        }
        catch (UncheckedExecutionException e) {
            this.logger.debug("error looking up region for bucket %s: %s", new Object[]{bucket, e});
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            this.logger.trace("bucket %s not found: %s", new Object[]{bucket, e});
        }
        return Optional.absent();
    }
}

