/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.IOException;
import java.util.Objects;
import java.util.Random;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public final class ShardGeneration
implements Writeable,
ToXContentFragment {
    private final String rawGeneration;

    public static ShardGeneration newGeneration() {
        return new ShardGeneration(UUIDs.randomBase64UUID());
    }

    public static ShardGeneration newGeneration(Random random) {
        return new ShardGeneration(UUIDs.randomBase64UUID(random));
    }

    public ShardGeneration(String rawGeneration) {
        this.rawGeneration = Objects.requireNonNull(rawGeneration);
    }

    public ShardGeneration(long legacyGeneration) {
        this.rawGeneration = String.valueOf(legacyGeneration);
    }

    public ShardGeneration(StreamInput in) throws IOException {
        this.rawGeneration = in.readString();
    }

    public static ShardGeneration fromXContent(XContentParser parser) throws IOException {
        String generationString = parser.textOrNull();
        return generationString == null ? null : new ShardGeneration(generationString);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.rawGeneration);
    }

    public String toBlobNamePart() {
        return this.rawGeneration;
    }

    public String toString() {
        return this.rawGeneration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardGeneration that = (ShardGeneration)o;
        return this.rawGeneration.equals(that.rawGeneration);
    }

    public int hashCode() {
        return Objects.hash(this.rawGeneration);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.value(this.rawGeneration);
        return builder;
    }
}

