/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.time.ZoneId;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.ConstantIndexFieldData;
import org.elasticsearch.index.mapper.ConstantFieldType;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;

public class TypeFieldMapper
extends MetadataFieldMapper {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(TypeFieldType.class);
    public static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Using the _type field in queries and aggregations is deprecated, prefer to use a field instead.";
    public static final String NAME = "_type";
    public static final String CONTENT_TYPE = "_type";
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.FixedTypeParser(c -> new TypeFieldMapper());

    public static void emitTypesDeprecationWarning() {
        deprecationLogger.deprecate(DeprecationCategory.TYPES, "query_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
    }

    private TypeFieldMapper() {
        super(new TypeFieldType(null));
    }

    @Override
    public void preParse(DocumentParserContext context) {
    }

    @Override
    protected String contentType() {
        return "_type";
    }

    public static final class TypeFieldType
    extends ConstantFieldType {
        private final String type;

        public TypeFieldType(String type) {
            super("_type", Collections.emptyMap());
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        @Override
        public String typeName() {
            return "_type";
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            TypeFieldMapper.emitTypesDeprecationWarning();
            return new ConstantIndexFieldData.Builder(this.type, this.name(), CoreValuesSourceType.KEYWORD);
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            throw new UnsupportedOperationException("Cannot fetch values for internal field [" + this.name() + "].");
        }

        @Override
        public Query existsQuery(SearchExecutionContext context) {
            TypeFieldMapper.emitTypesDeprecationWarning();
            return new MatchAllDocsQuery();
        }

        @Override
        protected boolean matches(String pattern, boolean caseInsensitive, SearchExecutionContext context) {
            TypeFieldMapper.emitTypesDeprecationWarning();
            if (this.type == null) {
                return false;
            }
            return Regex.simpleMatch(pattern, this.type, caseInsensitive);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, ZoneId timeZone, DateMathParser parser, SearchExecutionContext context) {
            TypeFieldMapper.emitTypesDeprecationWarning();
            BytesRef lower = (BytesRef)lowerTerm;
            BytesRef upper = (BytesRef)upperTerm;
            if (includeLower ? lower.utf8ToString().compareTo(this.type) > 0 : lower.utf8ToString().compareTo(this.type) >= 0) {
                return new MatchNoDocsQuery();
            }
            if (includeUpper ? upper.utf8ToString().compareTo(this.type) < 0 : upper.utf8ToString().compareTo(this.type) <= 0) {
                return new MatchNoDocsQuery();
            }
            return new MatchAllDocsQuery();
        }

        public Query typeFilter(String[] types) {
            for (String t : types) {
                if (!Objects.equals(this.type, t)) continue;
                return new MatchAllDocsQuery();
            }
            return new MatchNoDocsQuery();
        }
    }

    public static class Defaults {
        public static final FieldType NESTED_FIELD_TYPE = new FieldType();

        static {
            NESTED_FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            NESTED_FIELD_TYPE.setTokenized(false);
            NESTED_FIELD_TYPE.setStored(false);
            NESTED_FIELD_TYPE.setOmitNorms(true);
            NESTED_FIELD_TYPE.freeze();
        }
    }
}

