/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.wro4j;

import java.util.Properties;
import org.fao.geonet.wro4j.DiskbackedCache;
import org.fao.geonet.wro4j.GeonetWroModelFactory;
import ro.isdc.wro.cache.CacheKey;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.cache.CacheValue;
import ro.isdc.wro.cache.impl.LruMemoryCacheStrategy;
import ro.isdc.wro.manager.factory.ConfigurableWroManagerFactory;
import ro.isdc.wro.model.factory.WroModelFactory;

public class GeonetworkWrojManagerFactory
extends ConfigurableWroManagerFactory {
    public static final String WRO4J_LOG = "geonetwork.wro4j";
    private static final String CACHE_PROP_KEY = "cacheStrategy";
    private static final String SIZE_PROP_KEY = "lruSize";
    private DiskbackedCache diskBackedCache = null;

    protected WroModelFactory newModelFactory() {
        return new GeonetWroModelFactory(){

            @Override
            protected Properties getConfigProperties() {
                return GeonetworkWrojManagerFactory.this.newConfigProperties();
            }
        };
    }

    protected CacheStrategy<CacheKey, CacheValue> newCacheStrategy() {
        Properties properties = this.newConfigProperties();
        int lruSize = Integer.parseInt(properties.getProperty(SIZE_PROP_KEY, "128"));
        switch (properties.getProperty(CACHE_PROP_KEY, "lru")) {
            case "disk-memory": {
                if (this.diskBackedCache == null) {
                    this.diskBackedCache = new DiskbackedCache(lruSize, null);
                }
                return this.diskBackedCache;
            }
        }
        return new LruMemoryCacheStrategy(lruSize);
    }

    public void destroy() {
        super.destroy();
        if (this.diskBackedCache != null) {
            this.diskBackedCache.destroy();
        }
    }
}

