/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.raw;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.hibernate.validator.internal.engine.valuehandling.UnwrapMode;
import org.hibernate.validator.internal.metadata.core.MetaConstraint;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.AbstractConstrainedElement;
import org.hibernate.validator.internal.metadata.raw.ConfigurationSource;
import org.hibernate.validator.internal.metadata.raw.ConstrainedElement;

public class ConstrainedField
extends AbstractConstrainedElement {
    private final Set<MetaConstraint<?>> typeArgumentsConstraints;

    public ConstrainedField(ConfigurationSource source, ConstraintLocation location, Set<MetaConstraint<?>> constraints, Set<MetaConstraint<?>> typeArgumentsConstraints, Map<Class<?>, Class<?>> groupConversions, boolean isCascading, UnwrapMode unwrapMode) {
        super(source, ConstrainedElement.ConstrainedElementKind.FIELD, location, constraints, groupConversions, isCascading, unwrapMode);
        this.typeArgumentsConstraints = typeArgumentsConstraints != null ? Collections.unmodifiableSet(typeArgumentsConstraints) : Collections.emptySet();
    }

    public Set<MetaConstraint<?>> getTypeArgumentsConstraints() {
        return this.typeArgumentsConstraints;
    }

    @Override
    public boolean isConstrained() {
        return super.isConstrained() || !this.typeArgumentsConstraints.isEmpty();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.getLocation().getMember() == null ? 0 : this.getLocation().getMember().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstrainedField other = (ConstrainedField)obj;
        return !(this.getLocation().getMember() == null ? other.getLocation().getMember() != null : !this.getLocation().getMember().equals(other.getLocation().getMember()));
    }
}

