/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.domain;

public class StatisticValues {
    private final double maximum;
    private final double minimum;
    private final double sampleCount;
    private final double sum;

    public StatisticValues(double maximum, double minimum, double sampleCount, double sum) {
        this.maximum = maximum;
        this.minimum = minimum;
        this.sampleCount = sampleCount;
        this.sum = sum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getSampleCount() {
        return this.sampleCount;
    }

    public double getSum() {
        return this.sum;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private double maximum;
        private double minimum;
        private double sampleCount;
        private double sum;

        public Builder maximum(double maximum) {
            this.maximum = maximum;
            return this;
        }

        public Builder minimum(double minimum) {
            this.minimum = minimum;
            return this;
        }

        public Builder sampleCount(double sampleCount) {
            this.sampleCount = sampleCount;
            return this;
        }

        public Builder sum(double sum) {
            this.sum = sum;
            return this;
        }

        public StatisticValues build() {
            return new StatisticValues(this.maximum, this.minimum, this.sampleCount, this.sum);
        }
    }
}

