/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.Map;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNHostOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNHostOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNHostOptionsProvider;
import org.tmatesoft.svn.core.internal.wc.SVNCompositeConfigFile;
import org.tmatesoft.svn.core.internal.wc.SVNConfigFile;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class DefaultSVNHostOptionsProvider
implements ISVNHostOptionsProvider {
    private final File myConfigDirectory;
    private SVNCompositeConfigFile myServersFile;
    private Map myServersOptions;

    public DefaultSVNHostOptionsProvider() {
        this(null);
    }

    public DefaultSVNHostOptionsProvider(File configDirectory) {
        this.myConfigDirectory = configDirectory == null ? SVNWCUtil.getDefaultConfigurationDirectory() : configDirectory;
    }

    public void setInMemoryServersOptions(Map serversOptions) {
        this.myServersOptions = serversOptions;
    }

    protected SVNCompositeConfigFile getServersFile() {
        if (this.myServersFile == null) {
            SVNConfigFile.createDefaultConfiguration(this.myConfigDirectory);
            SVNConfigFile userConfig = new SVNConfigFile(new File(this.myConfigDirectory, "servers"));
            SVNConfigFile systemConfig = new SVNConfigFile(new File(SVNFileUtil.getSystemConfigurationDirectory(), "servers"));
            this.myServersFile = new SVNCompositeConfigFile(systemConfig, userConfig);
            this.myServersFile.setGroupsToOptions(this.myServersOptions);
        }
        return this.myServersFile;
    }

    public ISVNHostOptions getHostOptions(SVNURL url) {
        return new DefaultSVNHostOptions(this.getServersFile(), url);
    }
}

