/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.backup;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.ServiceManager;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.User;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.mef.MEFLib;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.repository.specification.UserSpecs;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.locationtech.jts.util.Assert;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.stereotype.Service;

@Service
public class ArchiveAllMetadataJob
extends QuartzJobBean {
    @Autowired
    private ConfigurableApplicationContext context;
    @Autowired
    private ServiceManager serviceManager;
    @Autowired
    private SettingManager settingManager;
    @Autowired
    UserRepository userRepository;
    static final String CATALOG_ARCHIVE_BACKUP_FILE_PREFIX = "gn_backup";
    public static final String BACKUP_DIR = "backup_archive";
    public static final String BACKUP_LOG = "geonetwork.backup";
    private AtomicBoolean backupIsRunning = new AtomicBoolean(false);

    protected void executeInternal(JobExecutionContext jobContext) throws JobExecutionException {
        ServiceContext serviceContext = this.serviceManager.createServiceContext("backuparchive", this.context);
        serviceContext.setLanguage("eng");
        serviceContext.setAsThreadLocal();
        ApplicationContextHolder.set((ConfigurableApplicationContext)this.context);
        if (!this.settingManager.getValueAsBool("metadata/backuparchive/enable")) {
            Log.info((String)BACKUP_LOG, (Object)"Backup archive not enabled");
            return;
        }
        try {
            this.createBackup(serviceContext);
        }
        catch (Exception e) {
            Log.error((String)"geonetwork", (Object)("Error running " + ArchiveAllMetadataJob.class.getSimpleName()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createBackup(ServiceContext serviceContext) throws Exception {
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        GeonetworkDataDirectory dataDirectory = (GeonetworkDataDirectory)appContext.getBean(GeonetworkDataDirectory.class);
        Path stylePath = dataDirectory.getWebappDir().resolve("xml/schemas/");
        if (!this.backupIsRunning.compareAndSet(false, true)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        try {
            Log.info((String)BACKUP_LOG, (Object)"Starting backup of all metadata");
            MetadataRepository metadataRepository = serviceContext.getBean(MetadataRepository.class);
            this.loginAsAdmin(serviceContext);
            Specification harvested = Specification.where((Specification)MetadataSpecs.isHarvested((boolean)false)).and(Specification.not((Specification)MetadataSpecs.hasType((MetadataType)MetadataType.SUB_TEMPLATE)));
            List uuids = Lists.transform((List)metadataRepository.findAll(harvested), (Function)new Function<Metadata, String>(){

                @Nullable
                public String apply(@Nullable Metadata input) {
                    return input.getUuid();
                }
            });
            Log.info((String)BACKUP_LOG, (Object)("Backing up " + uuids.size() + " metadata"));
            String format = "full";
            boolean resolveXlink = true;
            boolean removeXlinkAttribute = false;
            boolean skipOnError = true;
            Path srcFile = MEFLib.doMEF2Export(serviceContext, new HashSet<String>(uuids), format, false, stylePath, resolveXlink, removeXlinkAttribute, skipOnError, true, true);
            Path backupDir = dataDirectory.getBackupDir().resolve(BACKUP_DIR);
            String today = new SimpleDateFormat("-yyyy-MM-dd-HH:mm").format(new Date());
            Path destFile = backupDir.resolve(CATALOG_ARCHIVE_BACKUP_FILE_PREFIX + today + ".zip");
            IO.deleteFileOrDirectory((Path)backupDir);
            Files.createDirectories(destFile.getParent(), new FileAttribute[0]);
            Files.move(srcFile, destFile, new CopyOption[0]);
            if (!Files.exists(destFile, new LinkOption[0])) {
                throw new Exception("Moving backup file failed!");
            }
            long timeMinutes = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - startTime);
            Log.info((String)BACKUP_LOG, (Object)("Backup finished. Backup time: " + timeMinutes + "  Backup file: " + destFile));
        }
        catch (Throwable t) {
            Log.error((String)BACKUP_LOG, (Object)"Failed to create a back up of metadata", (Throwable)t);
        }
        finally {
            this.backupIsRunning.set(false);
        }
    }

    private void loginAsAdmin(ServiceContext serviceContext) {
        User adminUser = (User)this.userRepository.findAll(UserSpecs.hasProfile((Profile)Profile.Administrator), (Pageable)PageRequest.of((int)0, (int)1)).getContent().get(0);
        Assert.isTrue((adminUser != null ? 1 : 0) != 0, (String)"The system does not have an admin user");
        UserSession session = new UserSession();
        session.loginAs(adminUser);
        serviceContext.setUserSession(session);
    }
}

