/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet;

import com.google.common.collect.Lists;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.DatabaseMigrationTask;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.schema.iso19139.ISO19139Namespaces;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

public class MetadataResourceDatabaseMigration
extends DatabaseMigrationTask {
    private static final ArrayList<Namespace> NAMESPACES = Lists.newArrayList((Object[])new Namespace[]{ISO19139Namespaces.GMD, ISO19139Namespaces.GCO});
    private static final String XPATH_RESOURCES = "*//*[contains(text(), '/resources.get?')]";
    private static final String XPATH_THUMBNAIL_WITH_NO_URL = "*//gmd:MD_BrowseGraphic[gmd:fileDescription/gco:CharacterString = 'thumbnail' or gmd:fileDescription/gco:CharacterString = 'large_thumbnail']/gmd:fileName/gco:CharacterString[not(starts-with(normalize-space(text()), 'http'))]";
    private static final String XPATH_THUMBNAIL_WITH_URL = "*//gmd:graphicOverview/gmd:MD_BrowseGraphic[gmd:fileDescription/gco:CharacterString]/gmd:fileName/gco:CharacterString[starts-with(normalize-space(text()), 'http')]";
    private static final String XPATH_ATTACHMENTS_WITH_URL = "*//gmd:CI_OnlineResource/gmd:linkage/gmd:URL";
    private static final String URL_ATTACHED_RESOURCES = "api/records/%s/attachments/";
    private static final Pattern pattern = Pattern.compile("(.*)\\/([a-zA-Z0-9_\\-]+)\\/([a-z]{2,3})\\/{1,2}resources.get\\?.*fname=([\\p{L}\\w\\s_=\\(\\)\\.\\-%:]+)(&.*|$)");

    public static boolean updateMetadataResourcesLink(@Nonnull Element xml, @Nullable String uuid, SettingManager settingManager) throws JDOMException {
        Element uuidElement;
        boolean changed = false;
        if (uuid == null && (uuidElement = Xml.selectElement((Element)xml, (String)"gmd:fileIdentifier/gco:CharacterString", NAMESPACES)) != null) {
            uuid = uuidElement.getText();
        }
        if (StringUtils.isNotEmpty((String)uuid)) {
            ArrayList links = Lists.newArrayList((Iterable)Xml.selectNodes((Element)xml, (String)XPATH_RESOURCES));
            for (Object element : links) {
                String url = element.getText();
                Matcher regexMatcher = pattern.matcher(url);
                element.setText(regexMatcher.replaceAll(settingManager.getNodeURL() + "api/records/" + uuid + "/attachments/$4"));
                changed = true;
            }
            ArrayList linksAttachmentsUrl = Lists.newArrayList((Iterable)Xml.selectNodes((Element)xml, (String)XPATH_ATTACHMENTS_WITH_URL, NAMESPACES));
            for (Object element : linksAttachmentsUrl) {
                String url = element.getText();
                if (url.indexOf(String.format(URL_ATTACHED_RESOURCES, uuid)) <= 0) continue;
                element.setText(url.replace(url.substring(0, url.indexOf("api/records/")), settingManager.getNodeURL()));
                changed = true;
            }
            ArrayList linksThumbnailsNoUrl = Lists.newArrayList((Iterable)Xml.selectNodes((Element)xml, (String)XPATH_THUMBNAIL_WITH_NO_URL, NAMESPACES));
            for (Element element : linksThumbnailsNoUrl) {
                String filename = element.getText();
                element.setText(String.format("%sapi/records/" + uuid + "/attachments/%s", settingManager.getNodeURL(), filename));
                changed = true;
            }
            ArrayList linksThumbnailsWithUrl = Lists.newArrayList((Iterable)Xml.selectNodes((Element)xml, (String)XPATH_THUMBNAIL_WITH_URL, NAMESPACES));
            for (Element element : linksThumbnailsWithUrl) {
                String url = element.getText();
                if (url.indexOf("api/records/") <= 0) continue;
                element.setText(url.replace(url.substring(0, url.indexOf("api/records/")), settingManager.getNodeURL()));
                changed = true;
            }
        } else {
            throw new UnsupportedOperationException("Metadata is not supported. UUID is not defined.");
        }
        return changed;
    }

    @Override
    public void update(Connection connection) throws SQLException {
        Log.debug((String)"geonetwork.database", (Object)"MetadataResourceDatabaseMigration");
        SettingManager settingManager = (SettingManager)this.applicationContext.getBean(SettingManager.class);
        try (PreparedStatement update = connection.prepareStatement("UPDATE metadata SET data=? WHERE id=?");){
            try (Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery(String.format("SELECT data, id, uuid FROM metadata WHERE data LIKE '%%%s%%'", settingManager.getServerURL()));){
                int numInBatch = 0;
                while (resultSet.next()) {
                    Element xml = Xml.loadString((String)resultSet.getString(1), (boolean)false);
                    int id = resultSet.getInt(2);
                    String uuid = resultSet.getString(3);
                    boolean changed = MetadataResourceDatabaseMigration.updateMetadataResourcesLink(xml, uuid, settingManager);
                    if (!changed) continue;
                    String updatedData = Xml.getString((Element)xml);
                    update.setString(1, updatedData);
                    update.setInt(2, id);
                    update.addBatch();
                    if (++numInBatch <= 200) continue;
                    update.executeBatch();
                    numInBatch = 0;
                }
                update.executeBatch();
            }
            catch (BatchUpdateException e) {
                Log.error((String)"geonetwork", (Object)("Error occurred while updating resource links:" + e.getMessage()), (Throwable)e);
                SQLException next = e.getNextException();
                while (next != null) {
                    Log.error((String)"geonetwork", (Object)("Next error: " + next.getMessage()), (Throwable)next);
                    next = e.getNextException();
                }
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    }
}

