/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;

class PolygonExtractor {
    public static final PolygonExtractor INSTANCE = new PolygonExtractor();

    PolygonExtractor() {
    }

    public List<Polygon> getPolygons(Geometry preProcessed) throws TransformException, FactoryException {
        final ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        if (preProcessed instanceof Polygon) {
            polygons.add((Polygon)preProcessed);
        } else {
            preProcessed.apply(new GeometryComponentFilter(){

                public void filter(Geometry geom) {
                    if (geom instanceof Polygon) {
                        polygons.add((Polygon)geom);
                    }
                }
            });
        }
        return polygons;
    }
}

