/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.map.legend;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import org.geotools.map.legend.Drawer;
import org.geotools.styling.Rule;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeatureType;

public class Glyph {
    private static Drawer drawer = Drawer.create();
    private static final int DEFAULT_WIDTH = 16;
    private static final int DEFAULT_HEIGHT = 16;
    private static final int DEFAULT_DEPTH = 2;
    private static final Color DEFAULT_BORDER = new Color(0, 0, 0);
    private static final Color DEFAULT_FILL = new Color(27, 158, 119, 255);

    public static BufferedImage image() {
        BufferedImage bi = new BufferedImage(16, 16, 2);
        return bi;
    }

    public static BufferedImage point(Rule rule) {
        BufferedImage bi = new BufferedImage(16, 16, 2);
        drawer.drawDirect(bi, drawer.feature(drawer.point(7, 7)), rule);
        return bi;
    }

    public static BufferedImage point(Color color, Color fill) {
        BufferedImage bi = new BufferedImage(16, 16, 2);
        Graphics2D gc = (Graphics2D)bi.getGraphics();
        gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BasicStroke stroke = new BasicStroke(1.0f);
        gc.setStroke(stroke);
        Color c = color;
        Color f = fill;
        if (c == null) {
            c = Color.BLACK;
        }
        if (f == null) {
            f = Color.LIGHT_GRAY;
        }
        gc.setColor(f);
        gc.fillRect(8, 7, 5, 5);
        gc.setColor(c);
        gc.drawRect(8, 7, 5, 5);
        return bi;
    }

    public static BufferedImage line(Rule rule) {
        BufferedImage bi = new BufferedImage(16, 16, 2);
        drawer.drawDirect(bi, drawer.feature(drawer.line(new int[]{1, 14, 6, 0, 11, 14, 15, 1})), rule);
        return bi;
    }

    public static BufferedImage line(Color color, int width) {
        BufferedImage bi = new BufferedImage(16, 16, 2);
        Graphics2D gc = (Graphics2D)bi.getGraphics();
        gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color2 = color;
        int width2 = width;
        if (color2 == null) {
            color2 = Color.BLACK;
        }
        if (width2 <= 0) {
            width2 = 1;
        }
        int finalWidth = width2;
        Color finalColor = color2;
        BasicStroke stroke = new BasicStroke(finalWidth);
        gc.setStroke(stroke);
        gc.setColor(finalColor);
        gc.drawLine(1, 13, 6, 2);
        gc.drawLine(6, 2, 9, 13);
        gc.drawLine(9, 13, 14, 2);
        return bi;
    }

    public static BufferedImage geometry(Rule rule) {
        BufferedImage bi = new BufferedImage(16, 16, 2);
        drawer.drawDirect(bi, drawer.feature(drawer.polygon(new int[]{1, 14, 3, 9, 4, 6, 6, 4, 9, 3, 14, 1, 14, 14})), rule);
        drawer.drawDirect(bi, drawer.feature(drawer.line(new int[]{0, 12, 6, 3, 11, 12, 15, 3})), rule);
        drawer.drawDirect(bi, drawer.feature(drawer.point(4, 4)), rule);
        return bi;
    }

    public static BufferedImage geometry(Color color, Color fill) {
        BufferedImage bi = new BufferedImage(16, 16, 2);
        Graphics2D gc = (Graphics2D)bi.getGraphics();
        gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BasicStroke stroke = new BasicStroke(1.0f);
        gc.setStroke(stroke);
        Color c = color;
        Color f = fill;
        if (c == null) {
            c = Color.BLACK;
        }
        if (f == null) {
            f = Color.LIGHT_GRAY;
        }
        gc.setColor(f);
        gc.fillRoundRect(2, 1, 13, 13, 2, 2);
        gc.setColor(c);
        gc.drawRoundRect(2, 1, 13, 13, 2, 2);
        return bi;
    }

    public static BufferedImage Polygon(Rule rule) {
        BufferedImage bi = new BufferedImage(16, 16, 2);
        drawer.drawDirect(bi, drawer.feature(drawer.polygon(new int[]{1, 14, 3, 9, 4, 6, 6, 4, 9, 3, 14, 1, 14, 14})), rule);
        return bi;
    }

    public static BufferedImage polygon(Color color, Color fill, int width) {
        int w;
        BufferedImage bi = new BufferedImage(16, 16, 2);
        Graphics2D gc = (Graphics2D)bi.getGraphics();
        gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color c = color;
        Color f = fill;
        int n = w = width > 0 ? width : 1;
        if (c == null) {
            c = Color.BLACK;
        }
        if (f == null) {
            f = Color.LIGHT_GRAY;
        }
        BasicStroke stroke = new BasicStroke(w);
        gc.setStroke(stroke);
        int[] xs = new int[]{1, 3, 4, 6, 9, 14, 14};
        int[] ys = new int[]{14, 9, 6, 4, 3, 1, 14};
        int nb = 7;
        gc.setColor(c);
        gc.fillPolygon(xs, ys, nb);
        gc.setColor(f);
        gc.drawPolygon(xs, ys, nb);
        return bi;
    }

    public static BufferedImage grid(Color a, Color b, Color c, Color d) {
        BufferedImage bi = new BufferedImage(16, 16, 2);
        Graphics2D gc = (Graphics2D)bi.getGraphics();
        gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (a == null) {
            a = Color.BLACK;
        }
        if (b == null) {
            b = Color.DARK_GRAY;
        }
        if (c == null) {
            c = Color.LIGHT_GRAY;
        }
        if (d == null) {
            d = Color.WHITE;
        }
        gc.setColor(a);
        gc.fillRect(0, 0, 7, 7);
        gc.setColor(b);
        gc.fillRect(7, 0, 15, 7);
        gc.setColor(c);
        gc.fillRect(0, 7, 7, 15);
        gc.setColor(d);
        gc.fillRect(7, 7, 15, 15);
        gc.setColor(Color.BLACK);
        gc.drawRect(0, 0, 7, 7);
        gc.drawRect(0, 0, 15, 7);
        gc.drawRect(0, 7, 7, 15);
        gc.drawRect(0, 7, 15, 15);
        return bi;
    }

    public static BufferedImage swatch(Color c) {
        BufferedImage bi = new BufferedImage(16, 16, 2);
        Graphics2D gc = (Graphics2D)bi.getGraphics();
        gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = c == null ? Color.GRAY : c;
        int saturation = color.getRed() + color.getGreen() + color.getBlue();
        Color contrast = saturation < 384 ? color.brighter() : color.darker();
        gc.setColor(color);
        gc.fillRoundRect(0, 0, 14, 14, 2, 2);
        gc.setColor(contrast);
        gc.drawRoundRect(0, 0, 14, 14, 2, 2);
        return bi;
    }

    public static BufferedImage palette(Color[] c) {
        int i;
        BufferedImage bi = new BufferedImage(16, 16, 2);
        Graphics2D gc = (Graphics2D)bi.getGraphics();
        gc.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color[] colors = new Color[16];
        Color color = Color.GRAY;
        if (c == null) {
            for (i = 0; i < 16; ++i) {
                color = Color.GRAY;
            }
        } else {
            for (i = 0; i < 16; ++i) {
                int lookup = i * c.length / 16;
                if (c[lookup] != null) {
                    color = c[lookup];
                }
                colors[i] = color;
            }
        }
        for (i = 0; i < 16; ++i) {
            gc.setColor(colors[i]);
            gc.drawLine(i, 0, i, 15);
        }
        gc.setColor(Color.GRAY);
        gc.drawRoundRect(0, 0, 14, 14, 2, 2);
        return bi;
    }

    public static BufferedImage icon(SimpleFeatureType ft) {
        if (ft == null || ft.getGeometryDescriptor() == null) {
            return null;
        }
        Class binding = ft.getGeometryDescriptor().getType().getBinding();
        if (Point.class.isAssignableFrom(binding) || MultiPoint.class.isAssignableFrom(binding)) {
            return Glyph.point(DEFAULT_BORDER, DEFAULT_FILL);
        }
        if (LineString.class.isAssignableFrom(binding) || MultiLineString.class.isAssignableFrom(binding) || LinearRing.class.isAssignableFrom(binding)) {
            return Glyph.line(DEFAULT_BORDER, 1);
        }
        if (Polygon.class.isAssignableFrom(binding) || MultiPolygon.class.isAssignableFrom(binding)) {
            return Glyph.polygon(DEFAULT_BORDER, DEFAULT_FILL, 1);
        }
        return Glyph.geometry(DEFAULT_BORDER, DEFAULT_FILL);
    }
}

