/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.config.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.ui.AdvancedDialog;
import org.openrdf.sesame.config.ui.RepositoryTable;
import org.openrdf.sesame.config.ui.util.GridBagUtil;
import org.openrdf.sesame.config.ui.util.Util;

public class RepositoryTab
extends JPanel
implements ActionListener,
ListSelectionListener {
    protected SystemConfig _config;
    protected RepositoryTable _table;
    protected JButton _detailsButton;
    protected JButton _addButton;
    protected JButton _cloneButton;
    protected JButton _removeButton;

    public RepositoryTab(SystemConfig config) {
        this._config = config;
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(8, 8, 8, 8));
        URL url = this.getClass().getResource("icons/repository.png");
        JLabel icon = new JLabel(new ImageIcon(url));
        GridBagUtil.constrain(this, icon, 0, 0, 1, 1, 0, 10, 0.0, 0.0, 0, 0, 4, 4);
        JTextArea explanation = Util.createReadOnlyTextArea("Use the list below to add repositories to, or remove repositories from Sesame,\nand to change their access control list, sail stack and other settings.", this.getBackground());
        GridBagUtil.constrain(this, explanation, 1, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 4, 4, 0);
        JTextArea title = Util.createTitle("Repositories for Sesame:", this.getBackground());
        GridBagUtil.constrain(this, title, 0, 1, 2, 1, 0, 17, 0.0, 0.0, 4, 0, 4, 0);
        GridBagUtil.constrain(this, this._createList(), 0, 2, 2, 1, 1, 10, 1.0, 1.0, 4, 0, 4, 0);
        GridBagUtil.constrain(this, this._createButtons(), 0, 3, 2, 1, 0, 13, 1.0, 0.0, 4, 0, 0, 0);
        this._table.getSelectionModel().addListSelectionListener(this);
        this._enableDisableComponents();
    }

    protected JScrollPane _createList() {
        JScrollPane list = new JScrollPane();
        this._table = new RepositoryTable(this._config);
        JViewport viewport = list.getViewport();
        viewport.add(this._table);
        viewport.setBackground(Color.white);
        viewport.setPreferredSize(new Dimension(450, 200));
        list.setVerticalScrollBarPolicy(22);
        return list;
    }

    protected JPanel _createButtons() {
        JPanel buttonPanel = new JPanel(new GridLayout(1, 3, 4, 0));
        URL url = this.getClass().getResource("icons/details-repository.png");
        this._detailsButton = new JButton(new ImageIcon(url));
        this._detailsButton.setToolTipText("Show details for selected repository");
        buttonPanel.add(this._detailsButton);
        this._detailsButton.addActionListener(this);
        url = this.getClass().getResource("icons/add-repository.png");
        this._addButton = new JButton(new ImageIcon(url));
        this._addButton.setToolTipText("Add new repository to list");
        buttonPanel.add(this._addButton);
        this._addButton.addActionListener(this);
        url = this.getClass().getResource("icons/clone-repository.png");
        this._cloneButton = new JButton(new ImageIcon(url));
        this._cloneButton.setToolTipText("Clone selected repository");
        buttonPanel.add(this._cloneButton);
        this._cloneButton.addActionListener(this);
        url = this.getClass().getResource("icons/remove-repository.png");
        this._removeButton = new JButton(new ImageIcon(url));
        this._removeButton.setToolTipText("Remove selected repository from list");
        buttonPanel.add(this._removeButton);
        this._removeButton.addActionListener(this);
        return buttonPanel;
    }

    public void valueChanged(ListSelectionEvent e) {
        this._enableDisableComponents();
    }

    protected void _enableDisableComponents() {
        boolean rowSelected = this._table.getSelectedRow() != -1;
        this._detailsButton.setEnabled(rowSelected);
        this._removeButton.setEnabled(rowSelected);
        this._cloneButton.setEnabled(rowSelected);
    }

    public void requestFocus() {
        if (this._table.isEditing()) {
            this._table.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    protected void _showAdvancedDialog() {
        Window owner = Util.getOwner(this);
        if (!this._config.hasARepository()) {
            Util.showWarningDialog(owner, "No repository selected.", "Advanced Settings");
        } else {
            String id = this._table.getIdentifierForSelectedRow();
            if (id == null) {
                Util.showWarningDialog(owner, "No repository selected.", "Advanced Settings");
            } else {
                AdvancedDialog dialog = new AdvancedDialog((Frame)owner, id, this._config);
                dialog.show();
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (this._table.stopCellEditing()) {
            if (source == this._addButton) {
                this._table.addNewRow();
            }
            if (source == this._cloneButton) {
                this._table.cloneRow();
            } else if (source == this._removeButton) {
                this._table.removeRow();
            } else if (source == this._detailsButton) {
                this._showAdvancedDialog();
            }
        }
        this.requestFocus();
    }
}

