/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.admin;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.NamespaceListener;
import org.openrdf.rio.ParseErrorListener;
import org.openrdf.rio.ParseException;
import org.openrdf.rio.Parser;
import org.openrdf.rio.StatementHandler;
import org.openrdf.rio.StatementHandlerException;
import org.openrdf.rio.ntriples.NTriplesParser;
import org.openrdf.rio.rdfxml.RdfXmlParser;
import org.openrdf.rio.turtle.TurtleParser;
import org.openrdf.sesame.admin.AdminListener;
import org.openrdf.sesame.admin.StatusReporter;
import org.openrdf.sesame.admin.UpdateException;
import org.openrdf.sesame.constants.RDFFormat;
import org.openrdf.sesame.repository.local.LocalService;
import org.openrdf.sesame.sail.RdfRepository;
import org.openrdf.sesame.sail.SailInternalException;
import org.openrdf.sesame.sail.SailUpdateException;
import org.openrdf.util.io.IOUtil;
import org.openrdf.util.log.ThreadLog;

public class RdfAdmin {
    private NumberFormat _nf = NumberFormat.getInstance();
    private RdfRepository _rdfRepository;
    private LocalService _service;

    public RdfAdmin(RdfRepository rdfRepository, LocalService service) {
        this(rdfRepository);
        this._service = service;
    }

    public RdfAdmin(RdfRepository rdfRepository) {
        if (rdfRepository == null) {
            throw new IllegalArgumentException("rdfRepository must not be null");
        }
        this._rdfRepository = rdfRepository;
    }

    public void removeStatements(Resource subject, URI predicate, Value object, AdminListener listener) throws UpdateException {
        try {
            listener.transactionStart();
            this._rdfRepository.startTransaction();
            listener.status("Removing statements...", -1, -1);
            int count = this._rdfRepository.removeStatements(subject, predicate, object);
            this._rdfRepository.commitTransaction();
            listener.notification("Removed " + count + " statements", -1, -1, null);
        }
        catch (SailUpdateException e) {
            listener.error("Failed to remove statements: " + e.getMessage(), -1, -1, null);
            throw new UpdateException(e);
        }
        catch (RuntimeException e) {
            listener.error("Unexpected error while removing statements: " + e.getMessage(), -1, -1, null);
            throw e;
        }
        finally {
            listener.transactionEnd();
        }
    }

    public void clearRepository(AdminListener listener) throws UpdateException {
        try {
            listener.transactionStart();
            this._rdfRepository.startTransaction();
            listener.status("Clearing repository...", -1, -1);
            this._rdfRepository.clearRepository();
            this._rdfRepository.commitTransaction();
            listener.status("Repository cleared", -1, -1);
        }
        catch (SailUpdateException e) {
            listener.error("Failed to clear the repository: " + e.getMessage(), -1, -1, null);
            throw new UpdateException(e);
        }
        catch (RuntimeException e) {
            listener.error("Unexpected error while removing statements: " + e.getMessage(), -1, -1, null);
            throw e;
        }
        finally {
            listener.transactionEnd();
        }
    }

    public int addRdfModel(InputStream in, String baseURL, AdminListener listener, boolean verifyData) throws UpdateException, IOException {
        return this.addRdfModel(in, baseURL, listener, RDFFormat.RDFXML, verifyData);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addRdfModel(InputStream inputStream, String baseURL, AdminListener listener, RDFFormat dataFormat, boolean verifyData) throws UpdateException, IOException {
        int statementCount;
        File tmpFile;
        block11: {
            int n;
            tmpFile = null;
            byte[] data = null;
            statementCount = 0;
            try {
                block10: {
                    try {
                        listener.transactionStart();
                        if (verifyData) {
                            tmpFile = this._createUploadTmpFile();
                            listener.status("Loading data", -1, -1);
                            ThreadLog.trace((String)"Loading data");
                            long totalBytes = 0L;
                            if (tmpFile != null) {
                                totalBytes = IOUtil.writeToFile((InputStream)inputStream, (File)tmpFile);
                                inputStream.close();
                            } else {
                                listener.warning("Unable to store data in tmp file, attempting to store it in main memory", -1, -1, null);
                                data = IOUtil.readFully((InputStream)inputStream);
                                inputStream.close();
                            }
                            listener.status("Data loaded (" + this._nf.format(totalBytes) + " bytes)", -1, -1);
                            inputStream = tmpFile != null ? new FileInputStream(tmpFile) : new ByteArrayInputStream(data);
                            statementCount = this._verifyData(inputStream, baseURL, dataFormat, listener);
                            inputStream.close();
                            if (statementCount == 0) {
                                listener.status("Data does not contain any statements", -1, -1);
                                ThreadLog.trace((String)"No statements found");
                                n = 0;
                                Object var13_14 = null;
                                break block10;
                            }
                            String msg = "Data is correct and contains " + this._nf.format(statementCount) + " statements";
                            listener.status(msg, -1, -1);
                            ThreadLog.trace((String)msg);
                            inputStream = tmpFile != null ? new FileInputStream(tmpFile) : new ByteArrayInputStream(data);
                        }
                        statementCount = this._processStatements(inputStream, baseURL, dataFormat, listener);
                        break block11;
                    }
                    catch (UpdateException e) {
                        listener.error("Failed to add statements: " + e.getMessage(), -1, -1, null);
                        throw e;
                    }
                    catch (RuntimeException e) {
                        listener.error("Unexpected error while adding statements: " + e.getMessage(), -1, -1, null);
                        throw e;
                    }
                }
                listener.transactionEnd();
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                listener.transactionEnd();
                inputStream.close();
                if (tmpFile == null) throw throwable;
                tmpFile.delete();
                throw throwable;
            }
            inputStream.close();
            if (tmpFile == null) return n;
            tmpFile.delete();
            return n;
        }
        Object var13_15 = null;
        listener.transactionEnd();
        inputStream.close();
        if (tmpFile == null) return statementCount;
        tmpFile.delete();
        return statementCount;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addRdfModel(Reader reader, String baseURL, AdminListener listener, RDFFormat dataFormat, boolean verifyData) throws UpdateException, IOException {
        int statementCount;
        File tmpFile;
        block21: {
            int e3;
            tmpFile = null;
            String data = null;
            statementCount = 0;
            try {
                block20: {
                    try {
                        listener.transactionStart();
                        if (verifyData) {
                            FileInputStream in;
                            tmpFile = this._createUploadTmpFile();
                            listener.status("Loading data", -1, -1);
                            ThreadLog.trace((String)"Loading data");
                            long totalChars = 0L;
                            if (tmpFile != null) {
                                try {
                                    FileOutputStream out = new FileOutputStream(tmpFile);
                                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
                                    totalChars = IOUtil.transfer((Reader)reader, (Writer)writer);
                                    reader.close();
                                    ((Writer)writer).close();
                                }
                                catch (UnsupportedEncodingException e2) {
                                    ThreadLog.error((String)"Unable to write data to tmp file using UTF-8", (Object)e2);
                                    throw new RuntimeException(e2);
                                }
                            } else {
                                listener.warning("Unable to store data in tmp file, attempting to store it in main memory", -1, -1, null);
                                data = IOUtil.readFully((Reader)reader);
                                reader.close();
                            }
                            listener.status("Data loaded (" + this._nf.format(totalChars) + " characters)", -1, -1);
                            if (tmpFile != null) {
                                try {
                                    in = new FileInputStream(tmpFile);
                                    reader = new InputStreamReader((InputStream)in, "UTF-8");
                                }
                                catch (UnsupportedEncodingException e3) {
                                    ThreadLog.error((String)"Unable to read data from tmp file using UTF-8", (Object)e3);
                                    throw new RuntimeException(e3);
                                }
                            } else {
                                reader = new StringReader(data);
                            }
                            statementCount = this._verifyData(reader, baseURL, dataFormat, listener);
                            reader.close();
                            if (statementCount == 0) {
                                listener.status("Data does not contain any statements", -1, -1);
                                ThreadLog.trace((String)"No statements found");
                                e3 = 0;
                                Object var14_18 = null;
                                break block20;
                            }
                            String msg = "Data is correct and contains " + this._nf.format(statementCount) + " statements";
                            listener.status(msg, -1, -1);
                            ThreadLog.trace((String)msg);
                            if (tmpFile != null) {
                                try {
                                    in = new FileInputStream(tmpFile);
                                    reader = new InputStreamReader((InputStream)in, "UTF-8");
                                }
                                catch (UnsupportedEncodingException e4) {
                                    ThreadLog.error((String)"Unable to read data from tmp file using UTF-8", (Object)e4);
                                    throw new RuntimeException(e4);
                                }
                            } else {
                                reader = new StringReader(data);
                            }
                        }
                        statementCount = this._processStatements(reader, baseURL, dataFormat, listener);
                        break block21;
                    }
                    catch (UpdateException e5) {
                        listener.error("Failed to add statements: " + e5.getMessage(), -1, -1, null);
                        throw e5;
                    }
                    catch (RuntimeException e6) {
                        listener.error("Unexpected error while adding statements: " + e6.getMessage(), -1, -1, null);
                        throw e6;
                    }
                }
                listener.transactionEnd();
            }
            catch (Throwable throwable) {
                Object var14_20 = null;
                listener.transactionEnd();
                reader.close();
                if (tmpFile == null) throw throwable;
                tmpFile.delete();
                throw throwable;
            }
            reader.close();
            if (tmpFile == null) return e3;
            tmpFile.delete();
            return e3;
        }
        Object var14_19 = null;
        listener.transactionEnd();
        reader.close();
        if (tmpFile == null) return statementCount;
        tmpFile.delete();
        return statementCount;
    }

    private int _verifyData(Object inputStreamOrReader, String baseURL, RDFFormat dataFormat, AdminListener listener) throws UpdateException, IOException {
        listener.status("Checking data for errors", -1, -1);
        ThreadLog.trace((String)"Checking data for errors");
        Parser rdfParser = this._createParser(dataFormat, baseURL, (ValueFactory)new ValueFactoryImpl());
        rdfParser.setVerifyData(true);
        rdfParser.setStopAtFirstError(false);
        rdfParser.setDatatypeHandling(20);
        DataVerifier errorHandler = new DataVerifier(listener);
        rdfParser.setStatementHandler((StatementHandler)errorHandler);
        rdfParser.setParseErrorListener((ParseErrorListener)errorHandler);
        try {
            if (inputStreamOrReader instanceof InputStream) {
                rdfParser.parse((InputStream)inputStreamOrReader, baseURL);
            } else if (inputStreamOrReader instanceof Reader) {
                rdfParser.parse((Reader)inputStreamOrReader, baseURL);
            } else {
                throw new IllegalArgumentException("inputStreamOrReader is of type: " + inputStreamOrReader.getClass());
            }
            int errorCount = errorHandler.getErrorCount();
            int statementCount = errorHandler.getStatementCount();
            if (errorCount > 0) {
                throw new UpdateException(errorCount + " errors found, please fix these first");
            }
            return statementCount;
        }
        catch (IOException e) {
            ThreadLog.warning((String)"unable to verify data", (Object)e);
            throw new UpdateException(e);
        }
        catch (ParseException e) {
            throw new UpdateException(e);
        }
        catch (StatementHandlerException e) {
            throw new UpdateException(e);
        }
    }

    /*
     * Loose catch block
     */
    private int _processStatements(Object inputStreamOrReader, String baseURL, RDFFormat dataFormat, AdminListener listener) throws UpdateException, IOException {
        StatusReporter statusReporter;
        block17: {
            listener.status("Processing statements from data", -1, -1);
            ThreadLog.trace((String)"Processing statements");
            statusReporter = new StatusReporter(60000L, listener);
            this._rdfRepository.startTransaction();
            statusReporter.start();
            Parser rdfParser = this._createParser(dataFormat, baseURL, this._rdfRepository.getValueFactory());
            rdfParser.setVerifyData(false);
            rdfParser.setStopAtFirstError(false);
            rdfParser.setDatatypeHandling(20);
            StatementInserter statHandler = new StatementInserter(listener, statusReporter);
            rdfParser.setStatementHandler((StatementHandler)statHandler);
            NamespaceCollector nsCollector = new NamespaceCollector();
            rdfParser.setNamespaceListener((NamespaceListener)nsCollector);
            if (inputStreamOrReader instanceof InputStream) {
                rdfParser.parse((InputStream)inputStreamOrReader, baseURL);
            } else if (inputStreamOrReader instanceof Reader) {
                rdfParser.parse((Reader)inputStreamOrReader, baseURL);
            } else {
                throw new IllegalArgumentException("inputStreamOrReader is of type: " + inputStreamOrReader.getClass());
            }
            listener.status("Updating extracted namespace prefixes", -1, -1);
            ThreadLog.trace((String)"Updating extracted namespace prefixes");
            Map namespaces = nsCollector.getNamespaces();
            Iterator prefixes = namespaces.keySet().iterator();
            while (prefixes.hasNext()) {
                String prefix = (String)prefixes.next();
                String namespace = (String)namespaces.get(prefix);
                try {
                    this._rdfRepository.changeNamespacePrefix(namespace, prefix);
                }
                catch (SailUpdateException e) {
                    listener.warning("Unable to set namespace prefix '" + prefix + "' for namespace '" + namespace + "': " + e.getMessage(), -1, -1, null);
                }
            }
            Object var15_18 = null;
            statusReporter.stopRunning();
            listener.status("Committing transaction...", -1, -1);
            ThreadLog.trace((String)"Committing transaction");
            try {
                this._rdfRepository.commitTransaction();
            }
            catch (SailInternalException e) {
                ThreadLog.error((String)"Internal Sail error", (Object)e);
                listener.status(e.getMessage(), -1, -1);
            }
            break block17;
            {
                catch (IOException e) {
                    ThreadLog.warning((String)"Unable to process data", (Object)e);
                    throw new UpdateException(e);
                }
                catch (ParseException e) {
                    ThreadLog.warning((String)"Parse error", (Object)((Object)e));
                    throw new UpdateException(e);
                }
                catch (StatementHandlerException e) {
                    ThreadLog.warning((String)"Statement handler exception", (Object)((Object)e));
                    throw new UpdateException(e);
                }
                catch (OutOfMemoryError e) {
                    ThreadLog.warning((String)"Out of memory");
                    listener.error("Out of memory", -1, -1, null);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var15_19 = null;
                statusReporter.stopRunning();
                listener.status("Committing transaction...", -1, -1);
                ThreadLog.trace((String)"Committing transaction");
                try {
                    this._rdfRepository.commitTransaction();
                }
                catch (SailInternalException e) {
                    ThreadLog.error((String)"Internal Sail error", (Object)e);
                    listener.status(e.getMessage(), -1, -1);
                }
                throw throwable;
            }
        }
        return statusReporter.getStatementCount();
    }

    private Parser _createParser(RDFFormat dataFormat, String baseURL, ValueFactory valFactory) {
        RdfXmlParser result = null;
        if (RDFFormat.RDFXML.equals((Object)dataFormat)) {
            result = new RdfXmlParser(valFactory);
        } else if (RDFFormat.NTRIPLES.equals((Object)dataFormat)) {
            result = new NTriplesParser(valFactory);
        } else if (RDFFormat.TURTLE.equals((Object)dataFormat)) {
            result = new TurtleParser(valFactory);
        } else {
            throw new IllegalArgumentException("Illegal value for parameter 'dataFormat'");
        }
        return result;
    }

    private File _createUploadTmpFile() {
        try {
            if (this._service != null) {
                return this._service.createTmpFile("upload", ".tmp");
            }
            ThreadLog.error((String)"Unable to create tmp file for uploaded data: local service not set");
        }
        catch (IOException e) {
            ThreadLog.error((String)"Unable to create tmp file for uploaded data", (Object)e);
        }
        return null;
    }

    private static class NamespaceCollector
    implements NamespaceListener {
        private Map _namespaceMap = new HashMap();

        private NamespaceCollector() {
        }

        public void handleNamespace(String prefix, String uri) {
            if (prefix != null && prefix.trim().length() > 0 && !this._namespaceMap.containsKey(prefix)) {
                this._namespaceMap.put(prefix, uri);
            }
        }

        public Map getNamespaces() {
            return this._namespaceMap;
        }
    }

    private class StatementInserter
    implements StatementHandler {
        private AdminListener _listener;
        private StatusReporter _statusReporter;

        public StatementInserter(AdminListener listener, StatusReporter statusReporter) {
            this._listener = listener;
            this._statusReporter = statusReporter;
        }

        public void handleStatement(Resource s, URI p, Value o) {
            try {
                RdfAdmin.this._rdfRepository.addStatement(s, p, o);
                this._statusReporter.statementAdded();
            }
            catch (SailUpdateException e) {
                this._listener.warning("Unable to add statement; " + e.getMessage().trim(), -1, -1, (Statement)new StatementImpl(s, p, o));
            }
        }
    }

    private class DataVerifier
    implements StatementHandler,
    ParseErrorListener {
        private AdminListener _listener;
        private int _errorCount;
        private int _statementCount;

        public DataVerifier(AdminListener listener) {
            this._listener = listener;
            this._errorCount = 0;
            this._statementCount = 0;
        }

        public int getErrorCount() {
            return this._errorCount;
        }

        public int getStatementCount() {
            return this._statementCount;
        }

        public void handleStatement(Resource subject, URI predicate, Value object) {
            ++this._statementCount;
        }

        public void warning(String msg, int lineNo, int colNo) {
            this._listener.notification(msg, lineNo, colNo, null);
        }

        public void error(String msg, int lineNo, int colNo) {
            this._listener.warning(msg, lineNo, colNo, null);
            ++this._errorCount;
        }

        public void fatalError(String msg, int lineNo, int colNo) {
            this._listener.error(msg, lineNo, colNo, null);
            ++this._errorCount;
        }
    }
}

